/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.processor;

import javax.annotation.Nonnull;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.MacroRegistry;
import org.qubership.atp.dataset.macros.cache.MacroCacheKey;
import org.qubership.atp.dataset.macros.exception.CtxEvalException;
import org.qubership.atp.dataset.macros.processor.AbstractMacroProcessor;
import org.qubership.atp.dataset.macros.processor.MacroContext;
import org.qubership.atp.dataset.service.direct.AliasWrapperService;

public class MacroProcessorImpl
extends AbstractMacroProcessor<MacroContext> {
    private final MacroCacheKey cache;

    public MacroProcessorImpl(@Nonnull EvaluationContext current, @Nonnull MacroRegistry registry, @Nonnull AliasWrapperService wrapperService, @Nonnull String inputText, @Nonnull MacroCacheKey cache) {
        super(new StringBuilder(inputText), registry);
        this.cache = cache;
        this.state = new MacroContext(wrapperService, current, this, registry, current);
    }

    @Override
    protected MacroContext createChildContext(@Nonnull MacroContext parent, @Nonnull String macro) {
        return new MacroContext(parent, macro);
    }

    @Override
    @Nonnull
    protected String getArguments(@Nonnull MacroContext macroContext) {
        return macroContext.args.toString();
    }

    @Override
    @Nonnull
    protected String getText(@Nonnull MacroContext macroContext) {
        return macroContext.text.toString();
    }

    @Override
    protected void dropArguments(@Nonnull MacroContext macroContext) {
        macroContext.beforeReevaluation();
    }

    @Override
    protected void dropText(@Nonnull MacroContext macroContext) {
        macroContext.text.setLength(0);
    }

    @Override
    protected void reduce(@Nonnull MacroContext parent, @Nonnull MacroContext child) throws CtxEvalException {
        super.reduce(parent, child);
        if (!child.doCache) {
            parent.doCache = false;
        }
    }

    @Override
    public String getValue() throws CtxEvalException {
        String result = super.getValue();
        if (((MacroContext)this.state).doCache) {
            this.cache.cacheValue(result);
        }
        return result;
    }
}

