/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.impl;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.MixInId;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.AbstractLabelProvider;
import org.qubership.atp.dataset.model.impl.MixInIdImpl;

public class DataSetImpl
extends AbstractLabelProvider
implements DataSet {
    private MixInId mixInId;
    private DataSetList dataSetList;
    private List<Parameter> parameters;
    private Boolean locked;

    public DataSetImpl() {
    }

    public DataSetImpl(MixInId id, String name, DataSetList dataSetList, List<Parameter> parameters, List<Label> labels, Boolean locked) {
        this.mixInId = id;
        this.name = name;
        this.dataSetList = dataSetList;
        this.parameters = parameters;
        this.labels = labels;
        this.locked = locked;
    }

    public DataSetImpl(UUID id, String name, DataSetList dataSetList, List<Parameter> parameters, List<Label> labels, Boolean locked) {
        this(new MixInIdImpl(id), name, dataSetList, parameters, labels, locked);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public UUID getId() {
        return this.getMixInId().getUuid();
    }

    @Override
    public void setId(UUID id) {
        this.getMixInId().setUuid(id);
    }

    @Override
    @Nonnull
    public Stream<Identified> getReferences() {
        Stream<DataSetList> result = Stream.of(this.getDataSetList());
        return Stream.concat(result, this.getParameters().stream());
    }

    @Override
    public Boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(Boolean isLock) {
        this.locked = isLock;
    }

    @Override
    public MixInId getMixInId() {
        return this.mixInId;
    }

    @Override
    public void setMixInId(MixInId id) {
        this.mixInId = id;
    }

    @Override
    public DataSetList getDataSetList() {
        return this.dataSetList;
    }

    @Override
    public void setDataSetList(DataSetList dataSetList) {
        this.dataSetList = dataSetList;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.getMixInId());
    }

    @Override
    public boolean equals(Object target) {
        return target != null && DataSet.class.isAssignableFrom(target.getClass()) && Objects.equals(this.mixInId, ((DataSet)DataSet.class.cast(target)).getMixInId());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mixInId", (Object)this.mixInId).add("name", (Object)this.name).toString();
    }
}

