/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.helper;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.LabelProvider;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.utils.ChangeType;
import org.qubership.atp.dataset.service.direct.helper.FileDataDao;

public interface CreationFacade {
    public TestPlan testPlan(@Nonnull VisibilityArea var1, @Nonnull String var2);

    public VisibilityArea va(@Nonnull String var1);

    public DataSetList dsl(@Nonnull VisibilityArea var1, @Nonnull String var2, @Nullable TestPlan var3);

    default public DataSetList dsl(@Nonnull VisibilityArea va, @Nonnull String name) {
        return this.dsl(va, name, null);
    }

    default public DataSetList dsl(String vaName, String name, @Nullable TestPlan testPlan) {
        return this.dsl(this.va(vaName), name, testPlan);
    }

    default public DataSetList dsl(String vaName, String name) {
        return this.dsl(this.va(vaName), name);
    }

    public DataSet ds(@Nonnull DataSetList var1, @Nonnull String var2);

    default public DataSet ds(String vaName, String dslName, String dsName) {
        return this.ds(this.dsl(vaName, dslName), dsName);
    }

    default public DataSet ds(VisibilityArea va, String dslName, String dsName) {
        return this.ds(this.dsl(va, dslName), dsName);
    }

    public Label label(@Nonnull LabelProvider var1, @Nonnull String var2);

    public Attribute attr(@Nonnull DataSetList var1, @Nonnull String var2, @Nonnull AttributeType var3, DataSetList var4, List<String> var5);

    public Parameter param(@Nonnull DataSet var1, @Nonnull Attribute var2, String var3, String var4, DataSet var5, @Nullable FileDataDao var6, @Nullable List<Attribute> var7);

    @Nonnull
    default public String schange(@Nonnull ChangeType operation, @Nullable List<UUID> args) {
        return operation.toText(args);
    }

    default public Parameter textParam(DataSet ds, String key, String text) {
        return this.textParam(ds, this.textAttr(ds.getDataSetList(), key), text);
    }

    default public Parameter textParam(DataSet ds, Attribute attr, String text) {
        return this.param(ds, attr, text, null, null, null, null);
    }

    default public Parameter schangeParam(DataSet ds, String key, DataSetList dslId, ChangeType operation, UUID ... args) {
        return this.schangeParam(ds, this.schangeAttr(ds.getDataSetList(), key, dslId), operation, args);
    }

    default public Parameter schangeParam(DataSet ds, Attribute attr, ChangeType operation, UUID ... args) {
        return this.textParam(ds, attr, this.schange(operation, Arrays.asList(args)));
    }

    default public Parameter refParam(DataSet from, DataSet to) {
        return this.refParam(from, to.getDataSetList().getName(), to);
    }

    default public Parameter refParam(DataSet from, String key, DataSet to) {
        return this.refParam(from, this.refAttr(from.getDataSetList(), key, to.getDataSetList()), to);
    }

    default public Parameter refParam(DataSet ds, Attribute refAttr, DataSet refDs) {
        return this.param(ds, refAttr, null, null, refDs, null, null);
    }

    default public Parameter listParam(DataSet ds, String key, String selectedListValue, String ... possibleListValues) {
        return this.listParam(ds, this.listAttr(ds.getDataSetList(), key, possibleListValues), selectedListValue);
    }

    default public Parameter listParam(DataSet ds, Attribute attr, String listValue) {
        return this.param(ds, attr, null, listValue, null, null, null);
    }

    default public Parameter fileParam(DataSet ds, String key, @Nonnull String fileName, @Nonnull String contentType) {
        return this.fileParam(ds, key, new FileDataDao(fileName, contentType));
    }

    default public Parameter fileParam(DataSet ds, String key, FileDataDao fileData) {
        return this.fileParam(ds, this.fileAttr(ds.getDataSetList(), key), fileData);
    }

    default public Parameter fileParam(DataSet ds, Attribute attr, FileDataDao fileData) {
        return this.param(ds, attr, null, null, null, fileData, null);
    }

    default public Parameter overrideParam(DataSet ds, Attribute attr, String text, String listValue, DataSet dsRef, FileDataDao fileData, Attribute ... pathToOverridden) {
        return this.overrideParam(ds, attr, text, listValue, dsRef, fileData, Arrays.asList(pathToOverridden));
    }

    default public Parameter overrideParam(DataSet ds, Attribute attr, String text, String listValue, DataSet dsRef, FileDataDao fileData, @Nonnull List<Attribute> pathToOverridden) {
        return this.param(ds, attr, text, listValue, dsRef, fileData, pathToOverridden);
    }

    default public Attribute schangeAttr(DataSetList dsl, String name, DataSetList dslRef) {
        return this.attr(dsl, name, AttributeType.CHANGE, dslRef, null);
    }

    default public Attribute textAttr(DataSetList dsl, String name) {
        return this.attr(dsl, name, AttributeType.TEXT, null, null);
    }

    default public Attribute refAttr(DataSetList dsl, String name, DataSetList dslRef) {
        return this.attr(dsl, name, AttributeType.DSL, dslRef, null);
    }

    default public Attribute fileAttr(DataSetList dsl, String name) {
        return this.attr(dsl, name, AttributeType.FILE, null, null);
    }

    default public Attribute listAttr(DataSetList dsl, String name, String ... listValues) {
        return this.attr(dsl, name, AttributeType.LIST, null, Arrays.asList(listValues));
    }

    default public Attribute listAttr(DataSetList dsl, String name, List<String> listValues) {
        return this.attr(dsl, name, AttributeType.LIST, null, listValues);
    }
}

