/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.helper;

import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.LabelProvider;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.TestPlan;
import org.qubership.atp.dataset.model.VisibilityArea;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.direct.IdentifiedService;
import org.qubership.atp.dataset.service.direct.helper.AbstractServicesInjected;
import org.qubership.atp.dataset.service.direct.helper.CreationFacade;
import org.qubership.atp.dataset.service.direct.helper.FileDataDao;
import org.qubership.atp.dataset.service.direct.helper.SimpleCreationFacade;

public class DbCreationFacade
extends AbstractServicesInjected
implements CreationFacade {
    private final AtomicInteger attrOrder = new AtomicInteger(0);

    @Override
    public VisibilityArea va(@Nonnull String name) {
        return this.visibilityAreaService.create(name);
    }

    @Override
    public DataSetList dsl(@Nonnull VisibilityArea va, @Nonnull String name, @Nullable TestPlan testPlan) {
        UUID testPlanId = testPlan != null ? testPlan.getId() : null;
        return this.dataSetListService.create(va.getId(), name, testPlanId);
    }

    @Override
    public TestPlan testPlan(@Nonnull VisibilityArea visibilityArea, @Nonnull String name) {
        return (TestPlan)this.testPlanService.create(visibilityArea.getId(), name).getFirst();
    }

    @Override
    public DataSet ds(@Nonnull DataSetList dsl, @Nonnull String name) {
        return this.dataSetService.create(dsl.getId(), name);
    }

    @Override
    public Attribute attr(@Nonnull DataSetList dsl, @Nonnull String name, @Nonnull AttributeType type, @Nullable DataSetList dslRef, @Nullable List<String> listValues) {
        UUID dslRefId = Optional.ofNullable(dslRef).map(Identified::getId).orElse(null);
        return this.attributeService.create(dsl.getId(), this.attrOrder.getAndIncrement(), name, type, dslRefId, listValues);
    }

    @Override
    public Parameter param(@Nonnull DataSet ds, @Nonnull Attribute attr, @Nullable String text, @Nullable String listValue, @Nullable DataSet dsRef, FileDataDao fileDataDto, @Nullable List<Attribute> path) {
        UUID dsRefId = Optional.ofNullable(dsRef).map(Identified::getId).orElse(null);
        ListValue lv = SimpleCreationFacade.getListValueByName(attr, listValue);
        UUID lvId = Optional.ofNullable(lv).map(Identified::getId).orElse(null);
        List<UUID> attrPathIds = null;
        if (path != null) {
            attrPathIds = path.stream().map(Identified::getId).collect(Collectors.toList());
        }
        Parameter result = this.parameterService.set(ds.getId(), attr.getId(), attrPathIds, text, dsRefId, lvId);
        if (fileDataDto != null) {
            FileData fileData = new FileData(fileDataDto.fileName, result.getId(), fileDataDto.contentType);
            this.gridFsService.save(fileData, new ByteArrayInputStream(fileDataDto.fileName.getBytes()), false);
            result.setFileData(fileData);
        }
        return result;
    }

    @Override
    public Label label(@Nonnull LabelProvider labelProvider, @Nonnull String name) {
        UUID targetId;
        IdentifiedService<DataSet> service;
        if (labelProvider instanceof DataSet) {
            service = this.dataSetService;
            targetId = ((DataSet)labelProvider).getId();
        } else if (labelProvider instanceof DataSetList) {
            service = this.dataSetListService;
            targetId = ((DataSetList)labelProvider).getId();
        } else {
            throw new IllegalArgumentException("No service found for [" + labelProvider.getClass().getSimpleName() + "] LabelProvider");
        }
        return service.mark(targetId, name);
    }
}

