/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.DatasetLinkAttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.DatasetLinkAttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.EncryptedAttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.EncryptedAttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.ListAttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.ListAttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.TextAttributeExportConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.TextAttributeImportConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AttributeTypeConverterEnum {
    TEXT("Text", TextAttributeImportConverter.class, TextAttributeExportConverter.class),
    LIST("List", ListAttributeImportConverter.class, ListAttributeExportConverter.class),
    ENCRYPTED("Encrypted", EncryptedAttributeImportConverter.class, EncryptedAttributeExportConverter.class),
    DSL("DSL", DatasetLinkAttributeImportConverter.class, DatasetLinkAttributeExportConverter.class);

    private static final Logger log;
    private String name;
    private Class<? extends AttributeImportConverter> importConverterClazz;
    private Class<? extends AttributeExportConverter> exportConverterClazz;
    private static Map<String, Class<? extends AttributeImportConverter>> importConverterClazzMap;
    private static Map<String, Class<? extends AttributeExportConverter>> exportConverterClazzMap;

    private AttributeTypeConverterEnum(String name, Class<? extends AttributeImportConverter> importConverterClazz, Class<? extends AttributeExportConverter> exportConverterClazz) {
        this.name = name;
        this.importConverterClazz = importConverterClazz;
        this.exportConverterClazz = exportConverterClazz;
    }

    public static Class<? extends AttributeImportConverter> getImportConverterClazzByName(String name) {
        log.debug("Get import converter class by name: {}", (Object)name);
        return importConverterClazzMap.get(name.toUpperCase());
    }

    public static Class<? extends AttributeExportConverter> getExportConverterClazzByName(String name) {
        log.debug("Get export converter class by name: {}", (Object)name);
        return exportConverterClazzMap.get(name.toUpperCase());
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends AttributeImportConverter> getImportConverterClazz() {
        return this.importConverterClazz;
    }

    public Class<? extends AttributeExportConverter> getExportConverterClazz() {
        return this.exportConverterClazz;
    }

    static {
        log = LoggerFactory.getLogger(AttributeTypeConverterEnum.class);
        importConverterClazzMap = Arrays.stream(AttributeTypeConverterEnum.values()).collect(Collectors.toMap(Enum::name, AttributeTypeConverterEnum::getImportConverterClazz));
        exportConverterClazzMap = Arrays.stream(AttributeTypeConverterEnum.values()).collect(Collectors.toMap(Enum::name, AttributeTypeConverterEnum::getExportConverterClazz));
    }
}

