/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.crypt.ConverterTools;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.importexport.converters.AbstractAttributeConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportContext;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportModel;
import org.qubership.atp.dataset.service.direct.importexport.models.DatasetParameterValue;
import org.qubership.atp.dataset.service.direct.importexport.models.ParameterImportResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EncryptedAttributeImportConverter
extends AbstractAttributeConverter
implements AttributeImportConverter {
    private static final Logger log = LoggerFactory.getLogger(EncryptedAttributeImportConverter.class);
    private static final String PARAM_VALUE_OVERWRITE_STAMP = "*********";
    private final ParameterService parameterService;

    @Override
    public ParameterImportResponse importAttributeParameter(AttributeImportModel importModel, DatasetParameterValue datasetParameterValue, AttributeImportContext importContext) throws Exception {
        log.debug("Import encrypted attribute parameter, import model: '{}', dataset param value: '{}', context: '{}'", new Object[]{importModel, datasetParameterValue, importContext});
        UUID attributeId = importModel.getId();
        String datasetName = datasetParameterValue.getDatasetName();
        UUID datasetId = datasetParameterValue.getDatasetId();
        String parameterValue = datasetParameterValue.getTextValue();
        String encodedParameterValue = ConverterTools.encode((byte[])parameterValue.getBytes());
        List<UUID> attributePath = importModel.getPath();
        String keyAttributeValue = importModel.getKey();
        boolean isParameterShouldBeOverwritten = !PARAM_VALUE_OVERWRITE_STAMP.equals(parameterValue);
        boolean isJavers = importContext.isJavers();
        log.debug("Is parameter should be overwritten: {}", (Object)isParameterShouldBeOverwritten);
        if (isParameterShouldBeOverwritten) {
            log.info("Import parameter for encrypted attribute Key '{}' Id '{}' in dataset '{}' with path '{}'", new Object[]{keyAttributeValue, attributeId, datasetName, attributePath});
            Parameter parameter = this.parameterService.setParamSelectJavers(datasetId, attributeId, attributePath, encodedParameterValue, null, null, isJavers);
            log.debug("Parameter with has been successfully imported: {}", (Object)parameter);
        }
        return new ParameterImportResponse(datasetId);
    }

    @Override
    public AttributeImportModel mapRowToImportModel(Map<Integer, String> row, AttributeImportContext importContext, ListIterator<Map<Integer, String>> rowsIterator) {
        log.debug("Map excel row to encrypted attribute import model");
        return this.mapTextRowToImportModel(row, importContext);
    }

    @Override
    public List<ParameterImportResponse> validate(AttributeImportModel model, AttributeImportContext context) {
        log.debug("Validate encrypted attribute import model. Import model: '{}', context: '{}'", (Object)model, (Object)context);
        return new ArrayList<ParameterImportResponse>();
    }

    public EncryptedAttributeImportConverter(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

