/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.direct.importexport.converters.AbstractAttributeConverter;
import org.qubership.atp.dataset.service.direct.importexport.converters.AttributeImportConverter;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportContext;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportModel;
import org.qubership.atp.dataset.service.direct.importexport.models.DatasetParameterValue;
import org.qubership.atp.dataset.service.direct.importexport.models.ParameterImportResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TextAttributeImportConverter
extends AbstractAttributeConverter
implements AttributeImportConverter {
    private static final Logger log = LoggerFactory.getLogger(TextAttributeImportConverter.class);
    private final ParameterService parameterService;

    @Override
    public ParameterImportResponse importAttributeParameter(AttributeImportModel importModel, DatasetParameterValue datasetParameterValue, AttributeImportContext importContext) throws Exception {
        log.debug("Import text attribute parameter, import model: '{}', dataset param value: '{}',  context: '{}'", new Object[]{importModel, datasetParameterValue, importContext});
        UUID attributeId = importModel.getId();
        UUID datasetId = datasetParameterValue.getDatasetId();
        String attributeName = importModel.getName();
        String datasetName = datasetParameterValue.getDatasetName();
        String keyAttributeValue = importModel.getKey();
        String parameterValue = datasetParameterValue.getTextValue();
        boolean isDataChanges = false;
        boolean isJavers = importContext.isJavers();
        boolean attributeShouldOverlap = this.isAttributeShouldOverlap(importModel, datasetParameterValue, importContext, parameter -> !parameterValue.equals(parameter.getText()));
        List<UUID> attributePath = !attributeShouldOverlap ? Collections.emptyList() : importModel.getPath();
        String paramValueTarget = this.getParamValueTarget(attributeShouldOverlap, datasetParameterValue, importContext, attributeId, datasetId, importModel, this.parameterService);
        if (!Objects.equals(parameterValue, paramValueTarget)) {
            log.info("Import parameter for text attribute Key '{}' Name '{}' in dataset '{}' with value '{}' and path '{}'", new Object[]{keyAttributeValue, attributeName, datasetName, parameterValue, attributePath});
            Parameter parameter2 = this.parameterService.setParamSelectJavers(datasetId, attributeId, attributePath, parameterValue, null, null, isJavers);
            isDataChanges = true;
            log.debug("Parameter with has been successfully imported to target database. Parameter: {} ", (Object)parameter2);
        } else {
            log.debug("Parameter import is complete. This parameter already exists in the target database, datasetParameterValue: {}", (Object)datasetParameterValue);
        }
        return new ParameterImportResponse(isDataChanges ? datasetId : null);
    }

    @Override
    public AttributeImportModel mapRowToImportModel(Map<Integer, String> row, AttributeImportContext importContext, ListIterator<Map<Integer, String>> rowsIterator) {
        log.debug("Map excel row to text attribute import model");
        return this.mapTextRowToImportModel(row, importContext);
    }

    @Override
    public List<ParameterImportResponse> validate(AttributeImportModel model, AttributeImportContext context) {
        log.debug("Validate text attribute import model. Import model: '{}', context: '{}'", (Object)model, (Object)context);
        return new ArrayList<ParameterImportResponse>();
    }

    public TextAttributeImportConverter(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

