/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.converters;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XlsxToListConverter {
    private static final Logger log = LoggerFactory.getLogger(XlsxToListConverter.class);
    private final OPCPackage xlsxPackage;
    private final List<Map<Integer, String>> sheetConvertList;

    public XlsxToListConverter(OPCPackage pkg, List<Map<Integer, String>> sheetConvertList) {
        this.xlsxPackage = pkg;
        this.sheetConvertList = sheetConvertList;
    }

    public void processSheet(Styles styles, SharedStrings strings, XSSFSheetXMLHandler.SheetContentsHandler sheetHandler, InputStream sheetInputStream) throws IOException, SAXException {
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = XMLHelper.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(styles, strings, sheetHandler, false);
            sheetParser.setContentHandler((ContentHandler)handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            String error = "SAX parser appears to be broken - " + e.getMessage();
            log.error(error);
            throw new RuntimeException(error);
        }
    }

    public void process() throws IOException, OpenXML4JException, SAXException {
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(this.xlsxPackage);
        XSSFReader xssfReader = new XSSFReader(this.xlsxPackage);
        StylesTable styles = xssfReader.getStylesTable();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        if (iter.hasNext()) {
            try (InputStream stream = iter.next();){
                this.processSheet((Styles)styles, (SharedStrings)strings, new SheetXmlConverter(), stream);
            }
        }
    }

    private class SheetXmlConverter
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private int currentRow = -1;
        private int currentCol = -1;

        private SheetXmlConverter() {
        }

        public void startRow(int rowNum) {
            this.currentRow = rowNum;
            this.currentCol = -1;
            XlsxToListConverter.this.sheetConvertList.add(new LinkedHashMap());
        }

        public void endRow(int rowNum) {
            log.debug("End of row then do nothing");
        }

        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            if (cellReference == null) {
                log.debug("gracefully handle missing CellRef here in a similar way as XSSFCell does");
                cellReference = new CellAddress(this.currentRow, this.currentCol).formatAsString();
            }
            short thisCol = new CellReference(cellReference).getCol();
            if (formattedValue == null) {
                log.debug("no need to append anything if we do not have a value");
                return;
            }
            this.currentCol = thisCol;
            ((Map)XlsxToListConverter.this.sheetConvertList.get(this.currentRow)).put(Integer.valueOf(thisCol), formattedValue);
        }
    }
}

