/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.importexport.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.service.direct.importexport.models.AttributeImportContext;
import org.qubership.atp.dataset.service.direct.importexport.models.DatasetParameterValue;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportUtils {
    private static final Logger log = LoggerFactory.getLogger(ImportUtils.class);
    private static final int DSL_ATTRIBUTE_REF_DS_PART_INDEX = 1;
    private static final String UNDERSCORE = "_";
    public static final String DSL_ATTRIBUTE_REF_DELIMITER = " -> ";
    public static final int ATTR_NAME_ROW_INDEX = 0;
    public static final int ATTR_TYPE_ROW_INDEX = 1;

    public static String getParameterDsRefName(String parameterValue) {
        if (ImportUtils.isArrowDelimiterPresent(parameterValue)) {
            String[] parameterValueParts = parameterValue.split(DSL_ATTRIBUTE_REF_DELIMITER);
            if (parameterValueParts.length > 1) {
                return parameterValueParts[1];
            }
            log.debug("Error in DSL parameter [{}] in Excel file, ", (Object)parameterValue);
            return null;
        }
        return parameterValue;
    }

    public static String getAttributeType(Map<Integer, String> row) {
        return ImportUtils.getCellValue(row, 1).toUpperCase();
    }

    public static String getAttributeName(Map<Integer, String> row) {
        return ImportUtils.getCellValue(row, 0);
    }

    public static String getCellValue(Map<Integer, String> row, int key) {
        return row.getOrDefault(key, "");
    }

    public static boolean isBlankRow(Map<Integer, String> row) {
        return row.entrySet().stream().allMatch(cell -> ((String)cell.getValue()).isEmpty());
    }

    public static boolean isArrowDelimiterPresent(String attributeName) {
        return !StringUtils.isEmpty((String)attributeName) && attributeName.contains(DSL_ATTRIBUTE_REF_DELIMITER);
    }

    public static String getDslAttributeKey(String datasetListName, String attributeName) {
        return datasetListName + UNDERSCORE + attributeName;
    }

    public static String getDslAttributeKey(Attribute attribute) {
        return ImportUtils.getDslAttributeKey(attribute.getDataSetList().getName(), attribute.getName());
    }

    public static String getDsParameterKey(Parameter parameter) {
        String datasetListName = parameter.getDataSet().getDataSetList().getName();
        String datasetName = parameter.getDataSet().getName();
        String attributeName = parameter.getAttribute().getName();
        return ImportUtils.getDsParameterKey(datasetListName, datasetName, attributeName);
    }

    public static String getDsParameterKey(DatasetParameterValue datasetParameterValue, String attributeName) {
        String datasetListName = datasetParameterValue.getDatasetListReference();
        String datasetName = datasetParameterValue.getDatasetReference();
        return ImportUtils.getDsParameterKey(datasetListName, datasetName, attributeName);
    }

    public static String getDsParameterKey(String datasetListName, String datasetName, String attributeName) {
        return datasetListName + UNDERSCORE + datasetName + UNDERSCORE + attributeName;
    }

    public static String getDatasetKey(String datasetListName, String datasetName) {
        return datasetListName + UNDERSCORE + datasetName;
    }

    public static String getDatasetKey(DataSet dataset) {
        return ImportUtils.getDatasetKey(dataset.getDataSetList().getName(), dataset.getName());
    }

    public static String getDatasetKey(DatasetParameterValue datasetParameterValue) {
        String datasetListReference = datasetParameterValue.getDatasetListReference();
        String datasetReference = datasetParameterValue.getDatasetReference();
        return ImportUtils.getDatasetKey(datasetListReference, datasetReference);
    }

    public static String getDatasetKeyPathName(DataSet dataset) {
        return ImportUtils.getDatasetKey(dataset.getDataSetList().getId().toString(), dataset.getName());
    }

    public static String getOverlapKey(AttributeKey attributeKey, AttributeImportContext importContext) {
        String datasetName = attributeKey.getDataSet().getName();
        String attributeName = attributeKey.getAttribute().getName();
        String key = attributeKey.getKey();
        List<String> keyParts = Arrays.asList(key.split(UNDERSCORE));
        String attributePath = keyParts.stream().map(subKey -> importContext.getAttribute(UUID.fromString(subKey))).map(Attribute::getName).collect(Collectors.joining(DSL_ATTRIBUTE_REF_DELIMITER));
        attributeName = attributePath.concat(DSL_ATTRIBUTE_REF_DELIMITER).concat(attributeName);
        return ImportUtils.getOverlapKey(datasetName, attributeName);
    }

    public static String getOverlapKey(String datasetName, String attributeName) {
        return datasetName + UNDERSCORE + attributeName;
    }
}

