/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.direct.macros.schange;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.dataset.db.DataSetListRepository;
import org.qubership.atp.dataset.db.DataSetRepository;
import org.qubership.atp.dataset.db.utils.Proxies;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.AttributeImpl;
import org.qubership.atp.dataset.model.impl.DataSetImpl;
import org.qubership.atp.dataset.model.impl.MixInIdImpl;
import org.qubership.atp.dataset.model.impl.ParameterImpl;
import org.qubership.atp.dataset.service.direct.macros.schange.ChangeParameter;
import org.qubership.atp.dataset.service.direct.macros.schange.MultiplicationEntry;
import org.qubership.atp.dataset.service.direct.macros.schange.TraverseMixinSupport;

public class MultiplicationMixin
extends TraverseMixinSupport {
    private final List<MultiplicationEntry> entries;
    private final DataSetList dsl;
    private final DataSet ds;
    private final DataSetListRepository dslRepo;
    private final DataSetRepository dsRepo;

    private MultiplicationMixin(List<MultiplicationEntry> entries, DataSetListRepository dslRepo, DataSetRepository dsRepo, DataSetList dsl, DataSet ds) {
        this.entries = entries;
        this.dsl = dsl;
        this.ds = ds;
        this.dslRepo = dslRepo;
        this.dsRepo = dsRepo;
    }

    public static DataSet create(List<MultiplicationEntry> entries, DataSetListRepository dslRepo, DataSetRepository dsRepo, DataSetList dsl, DataSet ds) {
        MultiplicationMixin traverseProxy = new MultiplicationMixin(entries, dslRepo, dsRepo, dsl, ds);
        return traverseProxy.proxy(ds);
    }

    @Override
    public Attribute proxy(Attribute of) {
        Optional<Attribute> replaceWith = this.entries.stream().filter(entry -> ((ChangeParameter.Multiplication)entry.getKey()).targetAttribute.getId().equals(of.getId())).findAny().map(entry -> new AttributeImpl(of.getId(), of.getName(), of.getDataSetList(), AttributeType.DSL, Proxies.withId(DataSetList.class, ((ChangeParameter.Multiplication)entry.getKey()).dataSetListId, this.dslRepo::getById), null, null));
        return super.proxy(replaceWith.orElse(of));
    }

    @Override
    public Parameter proxy(Parameter of) {
        Optional<Parameter> replaceWith = this.entries.stream().filter(entry -> ((ChangeParameter.Multiplication)entry.getKey()).targetParameter.getId().equals(of.getId())).findAny().map(entry -> new ParameterImpl(of.getId(), this.proxy(of.getAttribute()), of.getDataSet(), null, null, Proxies.withId(DataSet.class, (UUID)entry.getValue(), this.dsRepo::getById)));
        return super.proxy(replaceWith.orElse(of));
    }

    @Override
    public DataSet proxy(DataSet of) {
        if (!this.ds.equals(of)) {
            return of;
        }
        String metadata = this.entries.stream().map(entry -> ((UUID)entry.getValue()).toString()).collect(Collectors.joining());
        return super.proxy(new DataSetImpl(new MixInIdImpl(this.ds.getId(), metadata), this.ds.getName(), this.dsl, this.ds.getParameters(), this.ds.getLabels(), this.ds.isLocked()));
    }
}

