/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.delegates;

import java.io.Serializable;
import java.util.UUID;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.qubership.atp.dataset.db.jpa.Wrapper;
import org.qubership.atp.dataset.db.jpa.entities.AbstractUuidBasedEntity;

public abstract class AbstractObjectWrapper<T extends AbstractUuidBasedEntity>
extends Wrapper
implements Serializable {
    protected T entity;

    public AbstractObjectWrapper(T entity) {
        this.entity = entity;
    }

    public void remove() {
        if (((AbstractUuidBasedEntity)this.entity).isRemoved()) {
            return;
        }
        this.beforeRemove();
        entityManager.remove(entityManager.contains(this.entity) ? this.entity : entityManager.merge(this.entity));
        ((AbstractUuidBasedEntity)this.entity).setRemoved(true);
    }

    public void save(AbstractUuidBasedEntity entity) {
        if (!entityManager.isJoinedToTransaction()) {
            entityManager.joinTransaction();
        }
        Session session = (Session)entityManager.unwrap(Session.class);
        session.saveOrUpdate((Object)entity);
        entityManager.flush();
    }

    public void save() {
        this.save((AbstractUuidBasedEntity)this.entity);
    }

    public void insert(AbstractUuidBasedEntity entity, UUID id) {
        if (!entityManager.isJoinedToTransaction()) {
            entityManager.joinTransaction();
        }
        entity.setId(id);
        Session session = (Session)entityManager.unwrap(Session.class);
        session.replicate((Object)entity, ReplicationMode.EXCEPTION);
    }

    public void beforeRemove() {
    }

    public void replicate() {
        if (!entityManager.isJoinedToTransaction()) {
            entityManager.joinTransaction();
        }
        Session session = (Session)entityManager.unwrap(Session.class);
        session.replicate(this.entity, ReplicationMode.OVERWRITE);
    }

    public boolean equals(Object other) {
        if (other instanceof AbstractObjectWrapper) {
            AbstractObjectWrapper otherWrapper = (AbstractObjectWrapper)other;
            return ((AbstractUuidBasedEntity)this.entity).getId().equals(((AbstractUuidBasedEntity)otherWrapper.entity).getId());
        }
        return false;
    }

    public int hashCode() {
        return ((AbstractUuidBasedEntity)this.entity).hashCode();
    }

    public T getEntity() {
        return this.entity;
    }
}

