/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.delegates;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.qubership.atp.dataset.db.jpa.entities.AbstractAttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeEntity;
import org.qubership.atp.dataset.db.jpa.entities.AttributeKeyEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetEntity;
import org.qubership.atp.dataset.db.jpa.entities.DataSetListEntity;
import org.qubership.atp.dataset.db.jpa.entities.LabelEntity;
import org.qubership.atp.dataset.db.jpa.entities.ParameterEntity;
import org.qubership.atp.dataset.exception.file.FileDsCopyException;
import org.qubership.atp.dataset.exception.file.FileDsNotFoundToCopyException;
import org.qubership.atp.dataset.model.impl.DataSetShort;
import org.qubership.atp.dataset.service.jpa.delegates.AbstractObjectWrapper;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.delegates.Label;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.copy.AttributeCopyData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSet
extends AbstractObjectWrapper<DataSetEntity> {
    private static final Logger log = LoggerFactory.getLogger(DataSet.class);

    public DataSet(DataSetEntity entity) {
        super(entity);
    }

    public UUID getId() {
        return ((DataSetEntity)this.entity).getId();
    }

    public String getName() {
        return ((DataSetEntity)this.entity).getName();
    }

    public Long ordering() {
        return ((DataSetEntity)this.entity).getOrdering();
    }

    public boolean isLocked() {
        return ((DataSetEntity)this.entity).isLocked();
    }

    public void setLocked(boolean locked) {
        ((DataSetEntity)this.entity).setLocked(locked);
    }

    public DataSetList getDataSetList() {
        return modelsProvider.getDataSetList(((DataSetEntity)this.entity).getDataSetList());
    }

    public List<Parameter> getParameters() {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        List<ParameterEntity> parameters = ((DataSetEntity)this.entity).getParameters();
        for (ParameterEntity parameter : parameters) {
            result.add(modelsProvider.getParameter(parameter));
        }
        return result;
    }

    public Parameter getParameterByAttributeId(UUID attributeId) {
        List<ParameterEntity> parameters = ((DataSetEntity)this.entity).getParameters();
        for (ParameterEntity parameter : parameters) {
            if (!parameter.getAttribute().getId().equals(attributeId)) continue;
            return modelsProvider.getParameter(parameter);
        }
        return null;
    }

    public List<Label> getLabels() {
        LinkedList<Label> result = new LinkedList<Label>();
        for (LabelEntity labelEntity : ((DataSetEntity)this.entity).getLabels()) {
            result.add(modelsProvider.getLabel(labelEntity));
        }
        return result;
    }

    @Override
    public void beforeRemove() {
        List<Parameter> parameters = this.getParameters();
        for (Parameter parameter : parameters) {
            parameter.remove();
        }
        List<AttributeKey> overlaps = this.getOverlaps();
        for (AttributeKey overlap : overlaps) {
            overlap.remove();
        }
        List<DataSetEntity> list = ((DataSetListEntity)this.getDataSetList().getEntity()).getDataSets();
        DataSetEntity dataSetToRemove = null;
        for (DataSetEntity dataSet : list) {
            if (!dataSet.getId().equals(this.getId())) continue;
            dataSetToRemove = dataSet;
            break;
        }
        if (dataSetToRemove != null) {
            list.remove(dataSetToRemove);
        }
    }

    public List<AttributeKey> getOverlaps() {
        LinkedList<AttributeKey> result = new LinkedList<AttributeKey>();
        String nativeQuery = "select * from attribute_key where dataSet_id = :ds_id";
        entityManager.createNativeQuery(nativeQuery, AttributeKeyEntity.class).setParameter("ds_id", (Object)this.getId()).getResultList().forEach(o -> result.add(new AttributeKey((AttributeKeyEntity)o)));
        return result;
    }

    public Parameter insertParameter(UUID parameterId, UUID attributeId) {
        ParameterEntity parameterEntity = new ParameterEntity();
        parameterEntity.setDataSet((DataSetEntity)this.entity);
        Attribute attribute = modelsProvider.getAttributeById(attributeId);
        parameterEntity.setAttribute((AbstractAttributeEntity)attribute.getEntity());
        parameterEntity.setDataSet((DataSetEntity)this.entity);
        ((AttributeEntity)attribute.getEntity()).getParameters().add(parameterEntity);
        this.insert(parameterEntity, parameterId);
        return modelsProvider.getParameter(parameterEntity);
    }

    public Parameter createParameter(UUID attributeId) {
        ParameterEntity parameterEntity = new ParameterEntity();
        parameterEntity.setDataSet((DataSetEntity)this.entity);
        Attribute attribute = modelsProvider.getAttributeById(attributeId);
        parameterEntity.setAttribute((AbstractAttributeEntity)attribute.getEntity());
        parameterEntity.setDataSet((DataSetEntity)this.entity);
        ((AttributeEntity)attribute.getEntity()).getParameters().add(parameterEntity);
        this.save(parameterEntity);
        return modelsProvider.getParameter(parameterEntity);
    }

    public Parameter createOverlap(UUID attributeId, List<UUID> attributePath) {
        AttributeKeyEntity attributeKeyEntity = new AttributeKeyEntity();
        attributeKeyEntity.setDataSetList((DataSetListEntity)this.getDataSetList().getEntity());
        attributeKeyEntity.setDataSet((DataSetEntity)this.entity);
        Attribute attribute = modelsProvider.getAttributeById(attributeId);
        attributeKeyEntity.setAttribute((AttributeEntity)attribute.getEntity());
        attributeKeyEntity.setKey(StringUtils.join(attributePath, (String)"_"));
        this.save(attributeKeyEntity);
        ParameterEntity parameterEntity = new ParameterEntity();
        parameterEntity.setAttribute(attributeKeyEntity);
        parameterEntity.setDataSet((DataSetEntity)this.entity);
        this.save(parameterEntity);
        return modelsProvider.getParameter(parameterEntity);
    }

    public void setName(String name) {
        ((DataSetEntity)this.entity).setName(name);
    }

    public void setOrdering(Long ordering) {
        ((DataSetEntity)this.entity).setOrdering(ordering);
    }

    public void setDataSetList(UUID dataSetListId) {
        DataSetList dataSetList = modelsProvider.getDataSetListById(dataSetListId);
        Assertions.assertNotNull((Object)dataSetList, (String)("Cannot find data set list by id " + dataSetListId));
        ((DataSetEntity)this.entity).setDataSetList((DataSetListEntity)dataSetList.getEntity());
    }

    public void copyParametersTo(DataSet anotherDataSet, Map<UUID, AttributeCopyData> attributesMap) {
        for (Parameter parameter : this.getParameters()) {
            Attribute oldAttribute = parameter.getAttribute();
            if (oldAttribute == null) continue;
            if (attributesMap.containsKey(oldAttribute.getId())) {
                AttributeCopyData newAttribute = attributesMap.get(oldAttribute.getId());
                Parameter copyParameter = anotherDataSet.createParameter(newAttribute.getCopyId());
                switch (oldAttribute.getAttributeType()) {
                    case CHANGE: 
                    case ENCRYPTED: 
                    case TEXT: {
                        copyParameter.setStringValue(parameter.getStringValue());
                        break;
                    }
                    case DSL: {
                        copyParameter.setDataSetReferenceId(parameter.getDataSetReferenceId());
                        break;
                    }
                    case FILE: {
                        try {
                            gridFsService.copy(parameter.getId(), copyParameter.getId(), false);
                        }
                        catch (IllegalStateException | FileDsCopyException | FileDsNotFoundToCopyException e) {
                            log.error("File " + parameter.getId() + " not found. Continue copying.", (Throwable)e);
                        }
                        break;
                    }
                    case LIST: {
                        if (parameter.getListValue() == null) break;
                        UUID newListValueId = newAttribute.getListValuesMap().get(parameter.getListValue().getId());
                        copyParameter.setListValueId(newListValueId);
                        break;
                    }
                }
                continue;
            }
            log.error("Copy of old attribute with id = [{}] is not exist, old dslId: {}", (Object)oldAttribute.getId(), (Object)oldAttribute.getDataSetList().getId());
        }
    }

    public DataSetShort getShortInfo() {
        return new DataSetShort(this.getDataSetList().getId(), this.getId(), this.getName());
    }
}

