/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.exception.visibilityarea.VisibilityAreaNameException;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.JpaVisibilityAreaService;
import org.qubership.atp.dataset.service.jpa.delegates.VisibilityArea;
import org.qubership.atp.dataset.service.jpa.model.VisibilityAreaFlatModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JpaVisibilityAreaServiceImpl
implements JpaVisibilityAreaService {
    @Autowired
    protected ModelsProvider modelsProvider;
    @Autowired
    protected JpaDataSetListService dataSetListService;

    @Override
    @Transactional(readOnly=true)
    public List<VisibilityAreaFlatModel> getAll() {
        ArrayList<VisibilityAreaFlatModel> result = new ArrayList<VisibilityAreaFlatModel>();
        List<VisibilityArea> all = this.modelsProvider.getAllVisibilityAreas();
        all.forEach(item -> result.add(new VisibilityAreaFlatModel((VisibilityArea)item)));
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public VisibilityAreaFlatModel getFlatById(UUID visibilityAreaId) {
        VisibilityArea visibilityArea = this.modelsProvider.getVisibilityAreaById(visibilityAreaId);
        if (visibilityArea == null) {
            return null;
        }
        return new VisibilityAreaFlatModel(visibilityArea);
    }

    @Override
    @Transactional(readOnly=true)
    public VisibilityArea getById(UUID visibilityAreaId) {
        VisibilityArea visibilityArea = this.modelsProvider.getVisibilityAreaById(visibilityAreaId);
        if (visibilityArea == null) {
            return null;
        }
        return visibilityArea;
    }

    @Override
    @Transactional(readOnly=true)
    public List<VisibilityAreaFlatModel> getAllSortedByNameAsc() {
        ArrayList<VisibilityAreaFlatModel> result = new ArrayList<VisibilityAreaFlatModel>();
        List<VisibilityArea> all = this.modelsProvider.getAllVisibilityAreasOrderedByNameAsc();
        all.forEach(item -> result.add(new VisibilityAreaFlatModel((VisibilityArea)item)));
        return result;
    }

    @Override
    @Transactional
    public void deleteById(UUID visibilityAreaId) {
        this.modelsProvider.getVisibilityAreaById(visibilityAreaId).remove();
    }

    @Override
    @Transactional
    public UUID getOrCreateWithName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new VisibilityAreaNameException();
        }
        VisibilityArea visibilityArea = this.modelsProvider.getVisibilityAreaByName(name);
        if (visibilityArea != null) {
            return visibilityArea.getId();
        }
        return this.modelsProvider.createVisibilityArea(name).getId();
    }

    @Override
    @Transactional
    public VisibilityArea replicate(UUID id, String name) throws DataSetServiceException {
        if (StringUtils.isEmpty((String)name)) {
            throw new DataSetServiceException("Visibility area name can't be null or empty");
        }
        return this.modelsProvider.replicate(id, name);
    }

    @Override
    @Transactional
    public boolean setName(UUID visibilityAreaId, String newName) {
        if (StringUtils.isEmpty((String)newName)) {
            throw new VisibilityAreaNameException();
        }
        VisibilityArea visibilityArea = this.modelsProvider.getVisibilityAreaById(visibilityAreaId);
        if (visibilityArea == null) {
            return false;
        }
        visibilityArea.setName(newName);
        return true;
    }

    @Override
    public void copyDataSetListsToVisibilityArea(UUID sourceAreaId, UUID targetAreaId) {
        VisibilityArea visibilityArea = this.modelsProvider.getVisibilityAreaById(sourceAreaId);
        this.dataSetListService.copyDataSetLists(visibilityArea.getDataSetListIds(), true, targetAreaId, null, null, null);
    }
}

