/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model;

import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.model.utils.Utils;

public class PathStep {
    private String name;
    private UUID id;

    public PathStep(String identifier) {
        if (Utils.isUuid(identifier)) {
            this.id = UUID.fromString(identifier);
        } else {
            this.name = identifier;
        }
    }

    public PathStep(UUID id) {
        this.id = id;
    }

    public boolean matches(String name, UUID id) {
        if (id != null && this.id != null) {
            return id.equals(this.id);
        }
        if (StringUtils.isNotEmpty((String)name)) {
            return name.equals(this.name);
        }
        return false;
    }

    public boolean matches(PathStep other) {
        if (this.id != null) {
            return other.getId().equals(this.id);
        }
        return other.getName().equals(this.name);
    }

    public String toString() {
        return "Search Step: " + (this.name != null ? this.name : "") + (this.id != null ? this.id : "");
    }

    public String getName() {
        return this.name;
    }

    public UUID getId() {
        return this.id;
    }
}

