/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.dscontext;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.AttributeKey;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.DataSetList;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.dscontext.CycleChecker;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.GroupContext;
import org.qubership.atp.dataset.service.jpa.model.tree.OverlapNode;
import org.springframework.data.domain.Pageable;

public class DataSetListContext
implements Serializable {
    private static final long serialVersionUID = 8928150301939110223L;
    private UUID visibilityAreaId;
    private UUID dataSetListId;
    private String dataSetListName;
    private List<DataSetContext> dataSets = new LinkedList<DataSetContext>();
    private List<GroupContext> groups = new LinkedList<GroupContext>();
    private List<Integer> loadedColumns = new LinkedList<Integer>();
    private List<AttributeTypeName> loadedAttributes = new LinkedList<AttributeTypeName>();
    private OverlapNode rootOverlapNode;
    private List<UUID> pathRestrictions = null;

    public DataSetListContext(UUID dataSetListId) {
        this.dataSetListId = dataSetListId;
    }

    public DataSetListContext(DataSetList dataSetList, List<Integer> dataSetColumns, List<AttributeTypeName> attributeTypeNames, List<UUID> pathRestrictions) {
        this.loadedAttributes.addAll(attributeTypeNames);
        this.dataSetListId = dataSetList.getId();
        this.dataSetListName = dataSetList.getName();
        this.visibilityAreaId = dataSetList.getVisibilityArea().getId();
        this.loadedColumns.addAll(dataSetColumns);
        this.pathRestrictions = pathRestrictions;
        this.makeContext(dataSetList, dataSetColumns, attributeTypeNames, null);
    }

    public DataSetListContext(DataSetList dataSetList, List<Integer> dataSetColumns, List<AttributeTypeName> attributeTypeNames, List<UUID> pathRestrictions, Pageable pageable) {
        this.loadedAttributes.addAll(attributeTypeNames);
        this.dataSetListId = dataSetList.getId();
        this.dataSetListName = dataSetList.getName();
        this.visibilityAreaId = dataSetList.getVisibilityArea().getId();
        this.loadedColumns.addAll(dataSetColumns);
        this.pathRestrictions = pathRestrictions;
        this.makeContext(dataSetList, dataSetColumns, attributeTypeNames, pageable);
    }

    private void makeContext(DataSetList dataSetList, List<Integer> dataSetColumns, List<AttributeTypeName> attributeTypeNames, Pageable pageable) {
        CycleChecker cycleChecker = new CycleChecker();
        cycleChecker.openNode(dataSetList.getId());
        List<Attribute> contextAttributes = dataSetList.getAttributesByTypes(attributeTypeNames);
        this.rootOverlapNode = new OverlapNode(null, dataSetList.getId(), dataSetList.getDataSetsCount());
        for (Integer dataSetColumn : dataSetColumns) {
            DataSet rootDataSet = dataSetList.getDataSetByColumn(dataSetColumn);
            DataSetContext dataSetContext = new DataSetContext(dataSetColumn, rootDataSet, contextAttributes, null, null, this.pathRestrictions);
            this.dataSets.add(dataSetContext);
            List<AttributeKey> attributeKeysByDataSet = dataSetList.getAttributeKeysByDataSet(rootDataSet.getId());
            for (AttributeKey overlap : attributeKeysByDataSet) {
                this.rootOverlapNode.addOverlap(overlap.getPath(), dataSetColumn, overlap);
            }
        }
        List<Attribute> dataSetListAttributes = dataSetList.getDataSetListReferences();
        for (Attribute dataSetListAttribute : dataSetListAttributes) {
            UUID referencedDataSetListId = dataSetListAttribute.getTypeDataSetList().getId();
            if (this.pathRestrictions == null) {
                cycleChecker.openNode(referencedDataSetListId);
                this.groups.add(new GroupContext(this.dataSets, dataSetListAttribute, this.rootOverlapNode, new LinkedList<UUID>(), attributeTypeNames, cycleChecker, this.pathRestrictions, referencedDataSetListId, pageable));
                cycleChecker.closeNode(referencedDataSetListId);
                continue;
            }
            if (!this.pathRestrictions.get(0).equals(dataSetListAttribute.getId())) continue;
            this.groups.add(new GroupContext(this.dataSets, dataSetListAttribute, this.rootOverlapNode, new LinkedList<UUID>(), attributeTypeNames, cycleChecker, this.pathRestrictions.subList(1, this.pathRestrictions.size()), referencedDataSetListId, pageable));
            break;
        }
        cycleChecker.closeNode(dataSetList.getId());
    }

    public UUID getVisibilityAreaId() {
        return this.visibilityAreaId;
    }

    public UUID getDataSetListId() {
        return this.dataSetListId;
    }

    public String getDataSetListName() {
        return this.dataSetListName;
    }

    public List<DataSetContext> getDataSets() {
        return this.dataSets;
    }

    public List<GroupContext> getGroups() {
        return this.groups;
    }

    public List<Integer> getLoadedColumns() {
        return this.loadedColumns;
    }

    public List<AttributeTypeName> getLoadedAttributes() {
        return this.loadedAttributes;
    }

    public OverlapNode getRootOverlapNode() {
        return this.rootOverlapNode;
    }

    public List<UUID> getPathRestrictions() {
        return this.pathRestrictions;
    }

    public void setVisibilityAreaId(UUID visibilityAreaId) {
        this.visibilityAreaId = visibilityAreaId;
    }

    public void setDataSetListId(UUID dataSetListId) {
        this.dataSetListId = dataSetListId;
    }

    public void setDataSetListName(String dataSetListName) {
        this.dataSetListName = dataSetListName;
    }

    public void setDataSets(List<DataSetContext> dataSets) {
        this.dataSets = dataSets;
    }

    public void setGroups(List<GroupContext> groups) {
        this.groups = groups;
    }

    public void setLoadedColumns(List<Integer> loadedColumns) {
        this.loadedColumns = loadedColumns;
    }

    public void setLoadedAttributes(List<AttributeTypeName> loadedAttributes) {
        this.loadedAttributes = loadedAttributes;
    }

    public void setRootOverlapNode(OverlapNode rootOverlapNode) {
        this.rootOverlapNode = rootOverlapNode;
    }

    public void setPathRestrictions(List<UUID> pathRestrictions) {
        this.pathRestrictions = pathRestrictions;
    }
}

