/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.dsllazyload.referencedcontext;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.UUID;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.jpa.model.dscontext.ParameterContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;

public class RefParameter {
    private UUID dataSet;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String value;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String valueRef;
    private boolean overlap;
    @JsonIgnore
    private ParameterContext parameterContext;
    @JsonIgnore
    private AbstractParameter dataSetParameterResolved;
    @JsonIgnore
    private ParameterPositionContext positionContext;
    @JsonIgnore
    private DataSetParameterProvider parameterProvider;

    public RefParameter(UUID parentDataSetId, ParameterContext parameter, boolean isOverLap, ParameterPositionContext positionContext, DataSetParameterProvider parameterProvider) {
        this.dataSet = parentDataSetId;
        this.overlap = isOverLap;
        this.value = parameter.getValue();
        this.positionContext = positionContext;
        this.parameterProvider = parameterProvider;
        this.parameterContext = parameter;
        if (parameter.getType() == AttributeTypeName.DSL) {
            UUID dataSetReferenceId = parameter.getDataSetReferenceId();
            this.valueRef = dataSetReferenceId == null ? null : parameter.getDataSetReferenceId().toString();
        }
        if (parameter.getType() == AttributeTypeName.LIST) {
            UUID listValueId = parameter.getListValueId();
            this.valueRef = listValueId == null ? null : listValueId.toString();
        }
    }

    public RefParameter(UUID parentDataSetId, ParameterContext parameter, boolean isOverLap, ParameterPositionContext positionContext, DataSetParameterProvider parameterProvider, FileData fileInfo) {
        this.dataSet = parentDataSetId;
        this.overlap = isOverLap;
        this.value = parameter.getValue();
        this.positionContext = positionContext;
        this.parameterProvider = parameterProvider;
        this.parameterContext = parameter;
        if (parameter.getType() == AttributeTypeName.FILE) {
            this.value = fileInfo.getFileName();
            this.valueRef = "/attachment/" + parameter.getValue();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getValue() {
        if (this.value == null) {
            return null;
        }
        if (this.parameterContext.getType() != AttributeTypeName.DSL && this.parameterContext.getType() != AttributeTypeName.FILE) {
            this.dataSetParameterResolved = this.parameterProvider.getDataSetParameterResolved(null, this.parameterContext.getParameterId(), this.parameterContext.getType(), false, null, this.positionContext);
            return this.dataSetParameterResolved.getValue();
        }
        return this.value;
    }

    public UUID getDataSet() {
        return this.dataSet;
    }

    public String getValueRef() {
        return this.valueRef;
    }

    public boolean isOverlap() {
        return this.overlap;
    }

    public ParameterContext getParameterContext() {
        return this.parameterContext;
    }

    public AbstractParameter getDataSetParameterResolved() {
        return this.dataSetParameterResolved;
    }

    public ParameterPositionContext getPositionContext() {
        return this.positionContext;
    }

    public DataSetParameterProvider getParameterProvider() {
        return this.parameterProvider;
    }

    public void setDataSet(UUID dataSet) {
        this.dataSet = dataSet;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setValueRef(String valueRef) {
        this.valueRef = valueRef;
    }

    public void setOverlap(boolean overlap) {
        this.overlap = overlap;
    }

    @JsonIgnore
    public void setParameterContext(ParameterContext parameterContext) {
        this.parameterContext = parameterContext;
    }

    @JsonIgnore
    public void setDataSetParameterResolved(AbstractParameter dataSetParameterResolved) {
        this.dataSetParameterResolved = dataSetParameterResolved;
    }

    @JsonIgnore
    public void setPositionContext(ParameterPositionContext positionContext) {
        this.positionContext = positionContext;
    }

    @JsonIgnore
    public void setParameterProvider(DataSetParameterProvider parameterProvider) {
        this.parameterProvider = parameterProvider;
    }
}

