/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.ds.itf;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.DataSetGroup;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.DataSetTree;
import org.qubership.atp.dataset.service.jpa.model.tree.ds.itf.AttributeSerializer;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;

public class ItfContextSerializer
extends StdSerializer<DataSetTree> {
    public ItfContextSerializer() {
        this(null);
    }

    protected ItfContextSerializer(Class<DataSetTree> t) {
        super(t);
    }

    public void serialize(DataSetTree dataSetTree, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeStartObject();
        TreeMap<Long, AttributeSerializer> attributes = new TreeMap<Long, AttributeSerializer>();
        Map<String, AbstractParameter> parameters = dataSetTree.getParameters();
        for (String parameterName : parameters.keySet()) {
            AbstractParameter parameter = parameters.get(parameterName);
            AttributeSerializer serializer = AttributeSerializer.getSerializer(parameterName, parameter, jsonGenerator);
            attributes.put(parameter.getOrder(), serializer);
        }
        Map<String, DataSetGroup> groups = dataSetTree.getGroups();
        for (String groupName : groups.keySet()) {
            DataSetGroup group = groups.get(groupName);
            AttributeSerializer serializer = AttributeSerializer.getSerializer(groupName, group, jsonGenerator);
            attributes.put(group.getOrder(), serializer);
        }
        for (AttributeSerializer serializer : attributes.values()) {
            serializer.serialize();
        }
        jsonGenerator.writeEndObject();
        jsonGenerator.close();
    }
}

