/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params.macros;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.AbstractMacro;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;

public class DateMacro
extends AbstractMacro {
    public static final String MACRO_NAME = "DATE";
    @JsonIgnore
    private static String GROUP_SHIFT_REGEX = "([\\+\\-])([0-9]*)?([a-zA-Z])(.*)";
    @JsonIgnore
    private static Pattern groupShiftPattern = Pattern.compile(GROUP_SHIFT_REGEX);
    @JsonIgnore
    private static String SHIFT_REGEX = "([\\+\\-][0-9]*d)?([\\+\\-][0-9]*M)?([\\+\\-][0-9]*y)?([\\+\\-][0-9]*h)?([\\+\\-][0-9]*m)?([\\+\\-][0-9]*s)?(.*)";
    @JsonIgnore
    private static Pattern shiftPattern = Pattern.compile(SHIFT_REGEX);

    public DateMacro(String realMacroName, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        super(realMacroName, macroContext, parameterPositionContext);
    }

    @Override
    public String getEvaluatedValue(List<String> arguments) {
        if (arguments.size() == 1) {
            return this.makeDateString(null, new SimpleDateFormat(arguments.get(0).trim()));
        }
        if (arguments.size() == 2) {
            return this.makeDateString(arguments.get(0).trim(), new SimpleDateFormat(arguments.get(1).trim()));
        }
        throw new IllegalArgumentException("Wrong argument count");
    }

    private String makeDateString(String dateShift, SimpleDateFormat dateFormat) {
        Date date = new Date();
        if (StringUtils.isEmpty((String)dateShift)) {
            return dateFormat.format(date);
        }
        Matcher matcher = shiftPattern.matcher(dateShift);
        if (matcher.matches()) {
            block16: for (int i = 1; i < matcher.groupCount(); ++i) {
                Matcher groupMatcher;
                String shiftGroup = matcher.group(i);
                if (!Strings.isNotEmpty((CharSequence)shiftGroup) || !(groupMatcher = groupShiftPattern.matcher(shiftGroup)).matches()) continue;
                int val = this.getValue(groupMatcher.group(1), groupMatcher.group(2));
                switch (groupMatcher.group(3)) {
                    case "d": {
                        date = DateUtils.addDays((Date)date, (int)val);
                        continue block16;
                    }
                    case "M": {
                        date = DateUtils.addMonths((Date)date, (int)val);
                        continue block16;
                    }
                    case "y": {
                        date = DateUtils.addYears((Date)date, (int)val);
                        continue block16;
                    }
                    case "h": {
                        date = DateUtils.addHours((Date)date, (int)val);
                        continue block16;
                    }
                    case "m": {
                        date = DateUtils.addMinutes((Date)date, (int)val);
                        continue block16;
                    }
                    case "s": {
                        date = DateUtils.addSeconds((Date)date, (int)val);
                        continue block16;
                    }
                }
            }
        }
        return dateFormat.format(date);
    }

    private int getValue(String sign, String val) {
        return Integer.parseInt(sign + Optional.ofNullable(val).orElse("1"));
    }
}

