/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model.tree.params.macros;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.dataset.model.utils.Utils;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.PathStep;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.AbstractRef;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefMacro
extends AbstractRef {
    private static final Logger LOG = LoggerFactory.getLogger(RefMacro.class);
    public static final String MACRO_NAME = "REF";

    public RefMacro(String realMacroName, MacroContext macroContext, ParameterPositionContext parameterPositionContext) {
        super(realMacroName, macroContext, parameterPositionContext);
    }

    @Override
    public String getEvaluatedValue(List<String> arguments) {
        if (Objects.isNull(arguments)) {
            return null;
        }
        if (arguments.isEmpty()) {
            return "";
        }
        String[] splits = String.join((CharSequence)"", arguments).split("\\.");
        if (splits.length < 2) {
            throw new IllegalArgumentException("Invalid parameter path");
        }
        LinkedList<PathStep> attributeGroupsPath = new LinkedList<PathStep>();
        PathStep dataSet = new PathStep(splits[0]);
        this.collectDataSetUuid(dataSet);
        for (int i = 1; i < splits.length - 1; ++i) {
            attributeGroupsPath.add(new PathStep(splits[i]));
        }
        PathStep attribute = new PathStep(splits[splits.length - 1]);
        return this.getMacroContext().getTextParameter(dataSet, attributeGroupsPath, attribute);
    }

    @Override
    public String getUnevaluatedValue(String childrenValue) {
        if (StringUtils.isEmpty((String)childrenValue)) {
            return super.getUnevaluatedValue(childrenValue);
        }
        try {
            LinkedList<String> content = new LinkedList<String>();
            String[] splits = childrenValue.split("\\.");
            if (Utils.isUuid(splits[0])) {
                String dataSetName = this.getMacroContext().getDataSetName(UUID.fromString(splits[0]));
                if (dataSetName == null) {
                    dataSetName = splits[0];
                }
                content.add(dataSetName);
            } else {
                content.add(splits[0]);
            }
            for (int i = 1; i < splits.length; ++i) {
                if (Utils.isUuid(splits[i])) {
                    String attributeName = this.getMacroContext().getAttributeName(UUID.fromString(splits[i]));
                    if (attributeName == null) {
                        attributeName = splits[i];
                    }
                    content.add(attributeName);
                    continue;
                }
                content.add(splits[i]);
            }
            super.getUnevaluatedValue(StringUtils.join(content, (String)"."));
        }
        catch (Exception e) {
            LOG.debug("Error macro values translation", (Throwable)e);
        }
        return super.getUnevaluatedValue(childrenValue);
    }

    private void collectDataSetUuid(PathStep dataSet) {
        if (dataSet.getId() == null) {
            UUID dataSetId = this.getMacroContext().getDataSetIdByNameAndDataSetList(dataSet.getName(), this.getMacroContext().getDataSetListContext().getDataSetListId());
            if (dataSetId != null) {
                this.dataSets.add(dataSetId);
            }
        } else {
            this.dataSets.add(dataSet.getId());
        }
    }
}

