/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.advice;

import com.google.common.base.Throwables;
import org.qubership.atp.dataset.exception.EntityNotFoundException;
import org.qubership.atp.dataset.service.rest.ExceptionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class GlobalExceptionHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Value(value="${atp.handler.exception.include-stack-trace:false}")
    private boolean includeStackTrace;

    @ExceptionHandler(value={EntityNotFoundException.class})
    public ResponseEntity<ExceptionInfo> entityNotFoundExceptionHandle(EntityNotFoundException exception) {
        ExceptionInfo info = new ExceptionInfo();
        info.setMessage(exception.getMessage());
        info.setErrorCode(HttpStatus.NOT_FOUND.value());
        if (this.includeStackTrace) {
            info.setStackTrace(Throwables.getStackTraceAsString((Throwable)exception));
        }
        log.error(exception.getMessage(), (Throwable)exception);
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)info);
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    protected ResponseEntity<Object> handleException(AccessDeniedException exception) {
        log.error(exception.getMessage(), (Throwable)exception);
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).body((Object)exception.getMessage());
    }
}

