/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.dto.versioning;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;

@JsonTypeName(value="HistoryItem")
public class HistoryItemDto
implements Serializable {
    @JsonProperty(value="version")
    private Integer version;
    @JsonProperty(value="modifiedWhen")
    private String modifiedWhen;
    @JsonProperty(value="modifiedBy")
    private String modifiedBy;
    @JsonProperty(value="attribute")
    private String attribute;
    @JsonProperty(value="dataSet")
    private String dataSet;
    @JsonProperty(value="changeSummary")
    private String changeSummary;
    @JsonProperty(value="oldValue")
    private String oldValue;
    @JsonProperty(value="newValue")
    private String newValue;
    @JsonProperty(value="commitId")
    private BigDecimal commitId;

    public HistoryItemDto version(Integer version) {
        this.version = version;
        return this;
    }

    @Min(value=1L)
    @Schema(name="version", description="Version number of current changes", required=false)
    public @Min(value=1L) Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public HistoryItemDto modifiedWhen(String modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
        return this;
    }

    @Schema(name="modifiedWhen", example="2020-04-15T12:34:56.789Z", required=false)
    public String getModifiedWhen() {
        return this.modifiedWhen;
    }

    public void setModifiedWhen(String modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
    }

    public HistoryItemDto modifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @Schema(name="modifiedBy", example="Administrator", required=false)
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public HistoryItemDto attribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    @Schema(name="attribute", example="Account", required=false)
    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public HistoryItemDto dataSet(String dataSet) {
        this.dataSet = dataSet;
        return this;
    }

    @Schema(name="dataSet", example="TLNT-BASE-BVC-002", required=false)
    public String getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(String dataSet) {
        this.dataSet = dataSet;
    }

    public HistoryItemDto changeSummary(String changeSummary) {
        this.changeSummary = changeSummary;
        return this;
    }

    @Schema(name="changeSummary", example="Changed", required=false)
    public String getChangeSummary() {
        return this.changeSummary;
    }

    public void setChangeSummary(String changeSummary) {
        this.changeSummary = changeSummary;
    }

    public HistoryItemDto oldValue(String oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    @Schema(name="oldValue", example="OldValue23", required=false)
    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public HistoryItemDto newValue(String newValue) {
        this.newValue = newValue;
        return this;
    }

    @Schema(name="newValue", example="NewValue42", required=false)
    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public HistoryItemDto commitId(BigDecimal commitId) {
        this.commitId = commitId;
        return this;
    }

    @Valid
    @Schema(name="commitId", required=false)
    public BigDecimal getCommitId() {
        return this.commitId;
    }

    public void setCommitId(BigDecimal commitId) {
        this.commitId = commitId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoryItemDto historyItem = (HistoryItemDto)o;
        return Objects.equals(this.version, historyItem.version) && Objects.equals(this.modifiedWhen, historyItem.modifiedWhen) && Objects.equals(this.modifiedBy, historyItem.modifiedBy) && Objects.equals(this.attribute, historyItem.attribute) && Objects.equals(this.dataSet, historyItem.dataSet) && Objects.equals(this.changeSummary, historyItem.changeSummary) && Objects.equals(this.oldValue, historyItem.oldValue) && Objects.equals(this.newValue, historyItem.newValue) && Objects.equals(this.commitId, historyItem.commitId);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.modifiedWhen, this.modifiedBy, this.attribute, this.dataSet, this.changeSummary, this.oldValue, this.newValue, this.commitId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoryItemDto {\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    modifiedWhen: ").append(this.toIndentedString(this.modifiedWhen)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    attribute: ").append(this.toIndentedString(this.attribute)).append("\n");
        sb.append("    dataSet: ").append(this.toIndentedString(this.dataSet)).append("\n");
        sb.append("    changeSummary: ").append(this.toIndentedString(this.changeSummary)).append("\n");
        sb.append("    oldValue: ").append(this.toIndentedString(this.oldValue)).append("\n");
        sb.append("    newValue: ").append(this.toIndentedString(this.newValue)).append("\n");
        sb.append("    commitId: ").append(this.toIndentedString(this.commitId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

