/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.Pair;
import org.qubership.atp.auth.springbootstarter.entities.UserInfo;
import org.qubership.atp.auth.springbootstarter.ssl.Provider;
import org.qubership.atp.dataset.db.jpa.entities.AttributesSortType;
import org.qubership.atp.dataset.db.jpa.entities.UserSettingsEntity;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.model.utils.DatasetResponse;
import org.qubership.atp.dataset.model.utils.FilterPair;
import org.qubership.atp.dataset.model.utils.HttpUtils;
import org.qubership.atp.dataset.service.direct.AttributeService;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.qubership.atp.dataset.service.direct.DataSetListService;
import org.qubership.atp.dataset.service.direct.importexport.models.DatasetListImportResponse;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListExportService;
import org.qubership.atp.dataset.service.direct.importexport.service.DatasetListImportService;
import org.qubership.atp.dataset.service.jpa.JpaDataSetListService;
import org.qubership.atp.dataset.service.jpa.impl.DataSetListCheckService;
import org.qubership.atp.dataset.service.jpa.model.CyclesCheckResult;
import org.qubership.atp.dataset.service.jpa.model.DataSetListDependencyNode;
import org.qubership.atp.dataset.service.rest.CopyDataSetListsRequest;
import org.qubership.atp.dataset.service.rest.PaginationResponse;
import org.qubership.atp.dataset.service.rest.QueryParamFlag;
import org.qubership.atp.dataset.service.rest.View;
import org.qubership.atp.dataset.service.rest.dto.manager.AffectedDataSetList;
import org.qubership.atp.dataset.service.rest.server.CopyDataSetListsResponse;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dsl"})
public class DataSetListController {
    private static final Logger log = LoggerFactory.getLogger(DataSetListController.class);
    private final DataSetListService dslService;
    private final DataSetListCheckService dataSetListCheckService;
    private final ConcurrentModificationService concurrentModificationService;
    private final JpaDataSetListService jpaDataSetListService;
    private final AttributeService attributeService;
    private final Provider<UserInfo> userInfoProvider;
    private final DatasetListExportService datasetListExportService;
    private final DatasetListImportService importService;

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),#vaId,'CREATE')")
    @PutMapping(value={"/va/{vaId}"})
    @ApiOperation(value="Creates new DSL with name provided.")
    @Operation(summary="Creates new DSL with name provided.")
    public ResponseEntity<UUID> create(@PathVariable(value="vaId") UUID vaId, @RequestParam(value="name") String name, @RequestParam(value="testPlan", required=false) UUID testPlanId, HttpServletRequest request) {
        this.dslService.checkOnDuplicate(vaId, name);
        UUID dslId = this.dslService.create(vaId, name, testPlanId).getId();
        String url = request.getRequestURL().append("/").append(dslId.toString()).toString();
        URI uri = URI.create(url);
        return ResponseEntity.created((URI)uri).body((Object)dslId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'DELETE')")
    @DeleteMapping(value={"/{dataSetListId}"})
    @AuditAction(auditAction="Delete dataset list: {{#dataSetListId}}")
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Deletes selected DSL.")
    public void delete(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        DataSetList dataSetList = (DataSetList)this.dslService.get(dataSetListId);
        String dslName = dataSetList.getName();
        UUID projectId = dataSetList.getVisibilityArea().getId();
        this.dslService.delete(dataSetListId);
        log.info(((UserInfo)this.userInfoProvider.get()).getFullName() + " deleted the DSL \"" + dslName + "\" in project " + projectId);
    }

    @GetMapping
    @AuditAction(auditAction="Get all Dataset lists")
    @Operation(summary="Returns all dataSetLists.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataSetList.class)))})})
    @JsonView(value={View.CreatedModified.class})
    public List<DataSetList> getDataSetLists() {
        return this.dslService.getAll();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),#visibilityArea,'READ')")
    @GetMapping(value={"/va/{vaId}"})
    @AuditAction(auditAction="Get dataset list for project: {{#visibilityArea}}")
    @Operation(summary="Returns all dataSetLists for selected visibility area.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataSetList.class)))})})
    @JsonView(value={View.CreatedModified.class})
    public List<DataSetList> getDataSetLists(@PathVariable(value="vaId") UUID visibilityArea, @RequestParam(value="label", required=false) String labelName) {
        return this.dslService.getAll(visibilityArea, labelName);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}"})
    @AuditAction(auditAction="Get information about dataset list: {{#dataSetListId}}")
    @Operation(summary="Returns information about the selected DSL.")
    public Object getDataSetListInfo(@PathVariable(value="dataSetListId") UUID dataSetListId, @Parameter(in=ParameterIn.QUERY) @PathVariable(value="filterDs", required=false) List<UUID> filterByDatasets, @Parameter(in=ParameterIn.QUERY) @PathVariable(value="filterAttr", required=false) List<UUID> filterByAttributes, @RequestParam(value="flat", required=false) QueryParamFlag flat, @RequestParam(value="new", required=false) QueryParamFlag newOne, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate) {
        boolean doEvaluate = QueryParamFlag.isPresent(evaluate);
        if (QueryParamFlag.isPresent(newOne)) {
            return this.dslService.getAsTree(dataSetListId, doEvaluate, filterByDatasets, filterByAttributes, null, null, false, true);
        }
        if (QueryParamFlag.isPresent(flat)) {
            return this.dslService.getAsFlat(dataSetListId, doEvaluate);
        }
        return this.dslService.get(dataSetListId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @PostMapping(value={"/{dataSetListId}/filters"})
    @Operation(summary="Returns information about the selected DSL.")
    @AuditAction(auditAction="Get information about dataset list: {{#dataSetListId}}")
    public Object getDataSetListInfo(@PathVariable(value="dataSetListId") UUID dataSetListId, @RequestBody(required=false) @Nullable FilterPair<List<UUID>, List<UUID>> body, @RequestParam(value="evaluate", required=false) QueryParamFlag evaluate, @RequestParam(value="startIndex", required=false) Integer startIndex, @RequestParam(value="endIndex", required=false) Integer endIndex, @RequestParam(value="sort", required=false) Boolean isSortEnabled, @RequestParam(value="expandAll", required=false, defaultValue="true") boolean expandAll) {
        boolean doEvaluate = QueryParamFlag.isPresent(evaluate);
        List<UUID> filterByDatasets = null;
        List<UUID> filterByAttributes = null;
        if (body != null) {
            filterByDatasets = CollectionUtils.isEmpty((Collection)body.getDatasets()) ? null : body.getDatasets();
            filterByAttributes = CollectionUtils.isEmpty((Collection)body.getAttributes()) ? null : body.getAttributes();
        }
        UUID userId = ((UserInfo)this.userInfoProvider.get()).getId();
        if (isSortEnabled != null) {
            this.attributeService.saveAttributeSortConfigurationForUser(userId, isSortEnabled);
            return this.dslService.getAsTree(dataSetListId, doEvaluate, filterByDatasets, filterByAttributes, startIndex, endIndex, isSortEnabled, expandAll);
        }
        UserSettingsEntity sortEnabledEntity = this.attributeService.getAttributeSortConfigurationForUser(userId);
        boolean isSortConfigured = sortEnabledEntity != null && AttributesSortType.SORT_BY_NAME.equals((Object)sortEnabledEntity.getAttributesSortType());
        return this.dslService.getAsTree(dataSetListId, doEvaluate, filterByDatasets, filterByAttributes, startIndex, endIndex, isSortConfigured, expandAll);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}/ds/{ds}"})
    @AuditAction(auditAction="Get information about dataset: {{#dsId}} in dataset list: {{#dataSetListId}}")
    @Operation(summary="Returns information about the selected DS under DSL.")
    public Object getDataSetInfoByDataSetListIdAndId(@PathVariable(value="dataSetListId") UUID dataSetListId, @PathVariable(value="ds") UUID dsId) {
        return this.dslService.getAsTree(dataSetListId, true, Collections.singletonList(dsId), false);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}/full"})
    @AuditAction(auditAction="Get information about datasets in dataset list: {{#dataSetListId}}")
    @Operation(summary="Returns datasets full information of the selected DSL.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataSet.class)))})})
    public List<DataSet> getDataSetListFullInfo(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        DataSetList dataSetList = (DataSetList)this.dslService.get(dataSetListId);
        if (dataSetList == null) {
            return Collections.emptyList();
        }
        return dataSetList.getDataSets();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}/ds"})
    @AuditAction(auditAction="Get datasets in dataset list: {{#dataSetListId}}")
    @Operation(summary="Returns datasets id/name information of the selected DSL.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataSet.class)))})})
    @JsonView(value={View.CreatedModified.class})
    public List<DataSet> getDataSets(@PathVariable(value="dataSetListId") UUID dataSetListId, @RequestParam(value="skipEvaluate", required=false) QueryParamFlag skipEvaluate, @RequestParam(value="label", required=false) String labelName) {
        return this.dslService.getChildren(dataSetListId, !Objects.isNull(skipEvaluate) && !skipEvaluate.isPresent(), labelName);
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PostMapping(value={"/ds/all"})
    @AuditAction(auditAction="Get information about datasets in dataset lists: {{#dataSetListId}}")
    public List<DatasetResponse> getDataSetsWithNameAndDataSetList(@RequestBody List<UUID> dataSetListIds) {
        return this.dslService.getListOfDsIdsAndNameAndDslId(dataSetListIds);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/{dataSetListId}"})
    @AuditAction(auditAction="Rename dataset list: {{#dataSetListId}}")
    @Operation(summary="Renames selected DSL.")
    public ResponseEntity<Boolean> rename(@PathVariable(value="dataSetListId") UUID dataSetListId, @RequestParam(value="name", required=false) String name, @RequestParam(value="testPlan", required=false) UUID testPlanId, @RequestParam(value="clearTestPlan", required=false) QueryParamFlag clearTestPlan, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        boolean isModify = this.dslService.modify(dataSetListId, name, testPlanId, QueryParamFlag.isPresent(clearTestPlan));
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)isModify) : ResponseEntity.ok((Object)isModify);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'UPDATE')")
    @PutMapping(value={"/{dataSetListId}/label"})
    @AuditAction(auditAction="Add label for dataset list: {{#dataSetListId}}")
    public ResponseEntity<Label> addLabel(@PathVariable(value="dataSetListId") UUID dataSetListId, @RequestParam(value="name") String name, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        Label label = this.dslService.mark(dataSetListId, name);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)label) : ResponseEntity.ok((Object)label);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}/label"})
    @AuditAction(auditAction="Get labels for dataset list: {{#dataSetListId}}")
    public List<Label> getLabels(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        return this.dslService.getLabels(dataSetListId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'UPDATE')")
    @DeleteMapping(value={"/{dataSetListId}/label/{labelId}"})
    @AuditAction(auditAction="Delete label: {{#labelId}} for dataset list: {{#dataSetListId}}")
    public ResponseEntity<Boolean> deleteLabel(@PathVariable(value="dataSetListId") UUID dataSetListId, @PathVariable(value="labelId") UUID labelId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        boolean isUnmark = this.dslService.unmark(dataSetListId, labelId);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)isUnmark) : ResponseEntity.ok((Object)isUnmark);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),#vaId,'CREATE')")
    @PutMapping(value={"/va/{vaId}/dsl/{dataSetListId}/copy"})
    @AuditAction(auditAction="Copy dataset list: {{#dataSetListId}} with provided name: {{#name}}")
    @Operation(summary="Copy DSL with name provided.")
    public UUID copy(@PathVariable(value="dataSetListId") UUID dataSetListId, @PathVariable(value="vaId") UUID vaId, @RequestParam(value="name") String name, @RequestParam(value="type", required=false) Boolean withData, @RequestParam(value="testPlan", required=false) UUID testPlanId) throws Exception {
        log.info("Requested copying data set list {}", (Object)dataSetListId);
        return this.dslService.copy(vaId, dataSetListId, name, withData, testPlanId).getId();
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PostMapping(value={"/copy"})
    @AuditAction(auditAction="Copy dataset lists: {{#request.getDataSetListIds()}} with provided name")
    @Operation(summary="Copy DSL with name provided.")
    public List<CopyDataSetListsResponse> copy(@RequestBody CopyDataSetListsRequest request) {
        return this.jpaDataSetListService.copyDataSetLists(request.getDataSetListIds(), request.isUpdateReferences(), request.getPostfix(), request.getPrevNamePattern());
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PostMapping(value={"/ds/clone/bulk"})
    @AuditAction(auditAction="Copy dataset lists: {{#data.keySet()}} and datasets with provided name: {{#name}}")
    @Operation(summary="Copy DSLs and DSs. Uses for cloning of test plan on Catalog")
    public Map<UUID, Pair<UUID, UUID>> copyBulk(@RequestParam(value="name") String name, @RequestBody Map<UUID, Set<UUID>> data) {
        return this.dslService.copy(name, data);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}/getAffected"})
    @AuditAction(auditAction="Get affected attribute by deleting dataset list: {{#dataSetListId}}")
    @Operation(summary="Get affected attribute by deleting dsl( data set storage).")
    public PaginationResponse<TableResponse> getAffectedAttributes(@PathVariable(value="dataSetListId") UUID dataSetListId, @RequestParam(required=false) Integer page, @RequestParam(required=false) Integer size) {
        return this.dslService.getAffectedAttributes(dataSetListId, page, size);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}/getAffectedCount"})
    @AuditAction(auditAction="Get affected attribute count by deleting dataset list: {{#dataSetListId}}")
    @Operation(summary="Get affected attributes count by deleting dsl( data set storage).")
    public Long getAffectedAttributesCount(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        return this.dslService.getAffectedAttributesCount(dataSetListId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}/getAffectedDSL"})
    @AuditAction(auditAction="Get affected dataset list by deleting dataset list: {{#dataSetListId}}")
    @ResponseStatus(value=HttpStatus.PARTIAL_CONTENT)
    @Operation(summary="Get affected dsl by deleting dsl( data set storage).")
    public ResponseEntity<List<AffectedDataSetList>> getAffectedDataSetLists(@PathVariable(value="dataSetListId") UUID dataSetListId, @RequestParam(value="limit", required=false, defaultValue="10") Integer limit, @RequestParam(value="offset", required=false, defaultValue="0") Integer offset) {
        List<AffectedDataSetList> affectedDataSetLists = this.dslService.getAffectedDataSetLists(dataSetListId, limit, offset);
        if (affectedDataSetLists.isEmpty()) {
            return ResponseEntity.ok().build();
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.PARTIAL_CONTENT).body(affectedDataSetLists);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}/modifiedWhen"})
    @AuditAction(auditAction="Get dataset list: {{#dataSetListId}} modifiedWhen")
    @Operation(summary="Get dsl modifiedWhen.")
    public ResponseEntity<Timestamp> getModifiedWhen(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        Timestamp modifiedWhen = this.jpaDataSetListService.getModifiedWhen(dataSetListId);
        return ResponseEntity.ok((Object)modifiedWhen);
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @GetMapping(value={"/cyclesCheck"})
    @AuditAction(auditAction="Get affected attribute by deleting dataset list: {{#dataSetListId}}")
    @Operation(summary="Get affected attribute by deleting dsl( data set storage).")
    public CyclesCheckResult getCyclesCheck() {
        return this.dataSetListCheckService.checkOnCyclesAll();
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PostMapping(value={"/dependencies"})
    @AuditAction(auditAction="Get dependencies trees for dataset lists: {{#dataSetListIds}}")
    @Operation(summary="Get dataset lists dependencies trees")
    public List<DataSetListDependencyNode> getDependencies(@RequestBody List<UUID> dataSetListIds) {
        return this.jpaDataSetListService.getDependencies(dataSetListIds);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/{dataSetListId}/exists"})
    @AuditAction(auditAction="Check if dsl exists")
    @Operation(summary="Check if dsl exists.")
    public ResponseEntity<Void> existsById(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        return this.dslService.existsById(dataSetListId) ? ResponseEntity.ok().build() : ResponseEntity.notFound().build();
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PostMapping(value={"/dependenciesRecursive"})
    @AuditAction(auditAction="Get dependencies trees for dataset lists: {{#dataSetListIds}}")
    @Operation(summary="Get dataset lists dependencies trees")
    public List<DataSetListDependencyNode> getDependenciesRecursive(@RequestBody List<UUID> dataSetListIds) {
        return this.jpaDataSetListService.getDependenciesRecursive(dataSetListIds);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'READ')")
    @PostMapping(path={"/{dataSetListId}/export/excel"})
    @AuditAction(auditAction="Export dataset lists: {{#dataSetListId}} to excel file")
    @Operation(summary="Export dataset list to excel file")
    public ResponseEntity<InputStreamResource> exportDataSetList(@PathVariable(value="dataSetListId") UUID dataSetListId) {
        File fileExcel = this.datasetListExportService.exportDataSetList(dataSetListId);
        return HttpUtils.buildFileResponseEntity(fileExcel, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).DATASET_LIST.getName(),@dataSetListServiceImpl.get(#dataSetListId).getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/{dataSetListId}/import/excel"})
    @AuditAction(auditAction="Import dataset lists: {{#dataSetListId}} to excel file")
    @Operation(summary="Import dataset list from excel file")
    public DatasetListImportResponse importDataSetList(@RequestParam UUID projectId, @PathVariable UUID dataSetListId, HttpServletRequest request, @RequestParam(value="versioning", required=false, defaultValue="false") Boolean isJavers) throws Exception {
        return this.importService.importDataSetList(projectId, dataSetListId, (InputStream)request.getInputStream(), isJavers);
    }

    public DataSetListController(DataSetListService dslService, DataSetListCheckService dataSetListCheckService, ConcurrentModificationService concurrentModificationService, JpaDataSetListService jpaDataSetListService, AttributeService attributeService, Provider<UserInfo> userInfoProvider, DatasetListExportService datasetListExportService, DatasetListImportService importService) {
        this.dslService = dslService;
        this.dataSetListCheckService = dataSetListCheckService;
        this.concurrentModificationService = concurrentModificationService;
        this.jpaDataSetListService = jpaDataSetListService;
        this.attributeService = attributeService;
        this.userInfoProvider = userInfoProvider;
        this.datasetListExportService = datasetListExportService;
        this.importService = importService;
    }
}

