/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.qubership.atp.dataset.exception.dataset.DataSetNotFoundException;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.TableResponse;
import org.qubership.atp.dataset.model.utils.OverlapItem;
import org.qubership.atp.dataset.model.utils.OverlapIterator;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.jpa.JpaParameterService;
import org.qubership.atp.dataset.service.rest.QueryParamFlag;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/parameter"})
public class ParameterController {
    private static final Logger log = LoggerFactory.getLogger(ParameterController.class);
    private final ParameterService parameterService;
    private final DataSetService dsService;
    private final JpaParameterService jpaParameterService;
    private final ConcurrentModificationService concurrentModificationService;

    @PreAuthorize(value="@entityAccess.checkAccess(@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'CREATE')")
    @PutMapping(value={"/ds/{dataSetId}/attribute/{attributeId}"})
    @AuditAction(auditAction="Create new parameter for dataset: {{#dataSetId}} and attribute: {{#attributeId}}")
    @Operation(summary="Creates new parameter with provided text.")
    public ResponseEntity<UUID> create(@PathVariable(value="dataSetId") UUID dataSetId, @PathVariable(value="attributeId") UUID attributeId, @RequestParam(value="value", required=false) String value, @RequestParam(value="dataSetReference", required=false) UUID dataSetReference, @RequestParam(value="listValueReference", required=false) UUID listValueReference, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen, HttpServletRequest request) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        UUID parameterId = this.jpaParameterService.createParameter(dataSetId, attributeId, value, dataSetReference, listValueReference).getId();
        this.dsService.evictAllAffectedDatasetsFromContextCacheByDsId(dataSetId);
        String url = request.getRequestURL().append("/").append(parameterId.toString()).toString();
        URI uri = URI.create(url);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)httpStatus).location(uri)).body((Object)parameterId) : ResponseEntity.created((URI)uri).body((Object)parameterId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/ds/{dataSetId}/attribute/{attributeId}"})
    @AuditAction(auditAction="Update parameter value for dataset: {{#dataSetId}} and attribute: {{#attributeId}}")
    @Operation(summary="Updates value of the selected parameter.")
    public ResponseEntity<Parameter> update(@PathVariable(value="dataSetId") UUID dataSetId, @PathVariable(value="attributeId") UUID attributeId, @RequestParam(value="value", required=false) String value, @RequestParam(value="dataSetReference", required=false) UUID dataSetReference, @RequestParam(value="listValueReference", required=false) UUID listValueReference, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen, @RequestBody(required=false) List<UUID> attrPathIds) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        Parameter parameter = this.parameterService.set(dataSetId, attributeId, attrPathIds, value, dataSetReference, listValueReference);
        this.dsService.evictAllAffectedDatasetsFromContextCacheByDsId(dataSetId);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)parameter) : ResponseEntity.ok((Object)parameter);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#dataSetListId,'UPDATE')")
    @PostMapping(value={"/update/bulk"})
    @AuditAction(auditAction="Bulk update value of parameters")
    @Operation(summary="Updates value of the selected parameters. Please do not use for files or overlaps!")
    public ResponseEntity<Void> updateParameters(@RequestParam(value="value", required=false) String stringValue, @RequestParam(value="dataSetReference", required=false) UUID dataSetReference, @RequestParam(value="listValueReference", required=false) UUID listValueReference, @RequestParam(value="dataSetListId") UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen, @RequestParam(value="dataSetId", required=false) UUID dataSetId, @RequestBody(required=false) List<UUID> listIdsParametersToChange) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        boolean updated = this.jpaParameterService.bulkUpdateValues(stringValue, dataSetReference, listValueReference, dataSetListId, dataSetId, listIdsParametersToChange);
        this.dsService.evictAllAffectedDatasetsFromContextCacheByDslId(dataSetListId);
        return updated ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.status((int)HttpStatus.NOT_MODIFIED.value()).build();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(@attributeServiceImpl.get(#attributeId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/bulk/attribute/{attributeId}"}, consumes={"multipart/form-data"}, produces={"application/json"})
    @AuditAction(auditAction="Bulk update value of parameters in attribute: {{#attributeId}}")
    public ResponseEntity<List<Object>> bulkUpdateAttribute(@PathVariable(value="attributeId") UUID attributeId, @RequestParam(value="dataSetListId") UUID dataSetListId, @RequestParam(value="value", required=false) String value, @RequestParam(value="file", required=false) MultipartFile file, @RequestParam(value="dataSetsIds", required=false) List<UUID> dataSetsIds, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen, @RequestParam(value="attrPathIds", required=false) List<UUID> attrPathIds) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        List<Object> result = this.parameterService.bulkUpdate(dataSetListId, attrPathIds, dataSetsIds, attributeId, value, file);
        this.dsService.evictAllAffectedDatasetsFromContextCacheByDslId(dataSetListId);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body(result) : ResponseEntity.ok().body(result);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'DELETE')")
    @DeleteMapping
    @AuditAction(auditAction="Delete parameter value for dataset: {{#dataSetId}} and attribute: {{#attributeId}}")
    @Operation(summary="Deletes value of the selected parameter.")
    public ResponseEntity<Void> delete(@RequestParam(value="dataSetId") UUID dataSetId, @RequestParam(value="attributeId") UUID attributeId, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        boolean deleted = this.parameterService.delete(attributeId, dataSetId, dataSetListId, null);
        this.dsService.evictAllAffectedDatasetsFromContextCacheByDsId(dataSetId);
        return deleted ? (HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.ok().build()) : ResponseEntity.status((int)HttpStatus.NOT_MODIFIED.value()).build();
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @GetMapping(value={"/affected/by/"})
    @AuditAction(auditAction="Get all parameters which uses provided ListValue")
    @Operation(summary="Get all parameters which uses provided ListValue")
    public List<?> getAffectedParametersByListValue(@RequestParam(value="listValueId", required=false) UUID listValueId, @RequestParam(value="full", required=false) QueryParamFlag full) {
        boolean withDsl = QueryParamFlag.isPresent(full);
        return this.parameterService.getParametersAffectedByListValue(listValueId, withDsl);
    }

    @PreAuthorize(value="@entityAccess.isAuthenticated()")
    @PostMapping(value={"/affected/by/listValues"})
    @AuditAction(auditAction="Get all parameters which uses provided ListValue")
    @Operation(summary="Get all parameters which use provided ListValue")
    public List<TableResponse> getAffectedParametersByListValues(@RequestBody(required=false) List<UUID> listValueIds) {
        return this.parameterService.getParametersAffectedByListValues(listValueIds);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @GetMapping(value={"/ds/{dataSetId}"})
    @AuditAction(auditAction="Get parameters value in dataset: {{#dataSetId}}")
    @Operation(summary="Returns the parameters of selected DS.", responses={@ApiResponse(responseCode="200", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Parameter.class)))})})
    public List<Parameter> getDataSetParameters(@PathVariable(value="dataSetId") UUID dataSetId) {
        DataSet dataSet = (DataSet)this.dsService.get(dataSetId);
        if (dataSet != null) {
            return dataSet.getParameters();
        }
        return Collections.emptyList();
    }

    @PreAuthorize(value="@entityAccess.checkAccess(@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'READ')")
    @PostMapping(value={"/get/original"})
    @AuditAction(auditAction="Get original parameter value for dataset: {{#dataSetId}} and attribute: {{#targetAttrId}}")
    public ResponseEntity<Parameter> getOriginalParameter(@RequestParam(value="dataSetId") UUID dataSetId, @RequestParam(value="targetAttrId") UUID targetAttrId, @RequestParam(value="dataSetListId", required=false) UUID dataSetListId, @RequestParam(value="modifiedWhen", required=false) Long modifiedWhen, @RequestBody(required=false) List<UUID> attrPathIds) {
        DataSet dataSet = (DataSet)this.dsService.get(dataSetId);
        if (dataSet == null) {
            log.error("Data Set not found. Id='" + dataSetId + "'");
            throw new DataSetNotFoundException();
        }
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(dataSetListId, modifiedWhen);
        OverlapIterator overlapIterator = OverlapIterator.create(dataSet, targetAttrId, attrPathIds);
        overlapIterator.next();
        OverlapItem target = (OverlapItem)overlapIterator.next();
        Parameter parameter = target.getParameter().orElse(null);
        return ResponseEntity.status((HttpStatus)httpStatus).body((Object)parameter);
    }

    public ParameterController(ParameterService parameterService, DataSetService dsService, JpaParameterService jpaParameterService, ConcurrentModificationService concurrentModificationService) {
        this.parameterService = parameterService;
        this.dsService = dsService;
        this.jpaParameterService = jpaParameterService;
        this.concurrentModificationService = concurrentModificationService;
    }
}

