/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.rest.server.v2;

import io.swagger.v3.oas.annotations.Operation;
import java.net.URI;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.api.ParameterRequest;
import org.qubership.atp.dataset.service.direct.ConcurrentModificationService;
import org.qubership.atp.dataset.service.direct.DataSetService;
import org.qubership.atp.dataset.service.direct.ParameterService;
import org.qubership.atp.dataset.service.jpa.JpaParameterService;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v2/parameter"})
public class ParameterControllerV2 {
    private static final Logger log = LoggerFactory.getLogger(ParameterControllerV2.class);
    private final ParameterService parameterService;
    private final DataSetService dsService;
    private final JpaParameterService jpaParameterService;
    private final ConcurrentModificationService concurrentModificationService;

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.dataset.model.UserManagementEntities).ATTRIBUTE.getName(),@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'UPDATE')")
    @PostMapping(value={"/ds/{dataSetId}/attribute/{attributeId}"})
    @AuditAction(auditAction="Update parameter value for dataset: {{#dataSetId}} and attribute: {{#attributeId}}")
    @Operation(summary="Updates value of the selected parameter.")
    public ResponseEntity<Parameter> update(@PathVariable(value="dataSetId") UUID dataSetId, @PathVariable(value="attributeId") UUID attributeId, @RequestBody ParameterRequest requestBody) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(requestBody.getDataSetListId(), requestBody.getModifiedWhen());
        Parameter parameter = this.parameterService.set(dataSetId, attributeId, requestBody.getAttrPathIds(), requestBody.getValue(), requestBody.getDataSetReference(), requestBody.getListValueReference());
        this.dsService.evictAllAffectedDatasetsFromContextCacheByDsId(dataSetId);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ResponseEntity.status((HttpStatus)httpStatus).body((Object)parameter) : ResponseEntity.ok((Object)parameter);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(@dataSetServiceImpl.get(#dataSetId).getDataSetList().getVisibilityArea().getId(),'CREATE')")
    @PutMapping(value={"/ds/{dataSetId}/attribute/{attributeId}"})
    @AuditAction(auditAction="Create new parameter for dataset: {{#dataSetId}} and attribute: {{#attributeId}}")
    @Operation(summary="Creates new parameter with provided text.")
    public ResponseEntity<UUID> create(@PathVariable(value="dataSetId") UUID dataSetId, @PathVariable(value="attributeId") UUID attributeId, @RequestBody ParameterRequest requestBody, HttpServletRequest request) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(requestBody.getDataSetListId(), requestBody.getModifiedWhen());
        UUID parameterId = this.jpaParameterService.createParameter(dataSetId, attributeId, requestBody.getValue(), requestBody.getDataSetReference(), requestBody.getListValueReference()).getId();
        this.dsService.evictAllAffectedDatasetsFromContextCacheByDsId(dataSetId);
        String url = request.getRequestURL().append("/").append(parameterId.toString()).toString();
        URI uri = URI.create(url);
        return HttpStatus.IM_USED.equals((Object)httpStatus) ? ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)httpStatus).location(uri)).body((Object)parameterId) : ResponseEntity.created((URI)uri).body((Object)parameterId);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(#dataSetListId,'UPDATE')")
    @PostMapping(value={"/update/bulk"})
    @AuditAction(auditAction="Bulk update value of parameters v2")
    @Operation(summary="Updates value of the selected parameters. Please do not use for files or overlaps! v2")
    public ResponseEntity<Void> updateParameters(@RequestBody ParameterRequest requestBody) {
        HttpStatus httpStatus = this.concurrentModificationService.getHttpStatus(requestBody.getDataSetListId(), requestBody.getModifiedWhen());
        boolean updated = this.jpaParameterService.bulkUpdateValues(requestBody.getValue(), requestBody.getDataSetReference(), requestBody.getListValueReference(), requestBody.getDataSetListId(), requestBody.getDataSetId(), requestBody.getListIdsParametersToChange());
        this.dsService.evictAllAffectedDatasetsFromContextCacheByDslId(requestBody.getDataSetListId());
        return updated ? ResponseEntity.status((HttpStatus)httpStatus).build() : ResponseEntity.status((int)HttpStatus.NOT_MODIFIED.value()).build();
    }

    public ParameterControllerV2(ParameterService parameterService, DataSetService dsService, JpaParameterService jpaParameterService, ConcurrentModificationService concurrentModificationService) {
        this.parameterService = parameterService;
        this.dsService = dsService;
        this.jpaParameterService = jpaParameterService;
        this.concurrentModificationService = concurrentModificationService;
    }
}

