/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.ws;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.qubership.atp.dataset.mdc.MdcField;
import org.qubership.atp.dataset.service.ws.event.Event;
import org.qubership.atp.dataset.service.ws.event.EventExecutor;
import org.qubership.atp.dataset.service.ws.event.EventExecutorImpl;
import org.qubership.atp.dataset.service.ws.event.EventType;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

public class WebSocketDsHandler
extends TextWebSocketHandler {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketDsHandler.class);
    private static final EventExecutor executor = EventExecutorImpl.getInstance();

    public void handleTextMessage(WebSocketSession session, TextMessage messageRequest) throws Exception {
        MDC.clear();
        String message = (String)messageRequest.getPayload();
        LOGGER.debug("Received message from: {}\nmessage: {}", (Object)session.getLocalAddress(), (Object)message);
        try {
            Event event = (Event)OBJECT_MAPPER.readValue(message, Event.class);
            MdcUtils.put((String)MdcField.DATA_SET_LIST_ID.toString(), (String)event.getDataSetListId());
            MdcUtils.put((String)MdcField.DATA_SET_ID.toString(), (String)event.getDatasetId());
            MdcUtils.put((String)MdcField.ATTRIBUTE_ID.toString(), (String)event.getAttributeId());
            executor.execute(session, event);
        }
        catch (Throwable e) {
            LOGGER.error("Unable to execute even:\n" + message, e);
        }
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        LOGGER.info("Disconnected remote user from: {}", (Object)session.getLocalAddress().getHostName());
        try {
            Event event = new Event();
            event.setEventType(EventType.CLOSE);
            executor.execute(session, event);
            MDC.clear();
        }
        catch (Throwable e) {
            LOGGER.error("Unable to execute event", e);
        }
        super.afterConnectionClosed(session, status);
    }
}

