/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.model.domain;

import java.util.LinkedList;
import java.util.UUID;
import joptsimple.internal.Strings;
import org.javers.core.metamodel.annotation.Value;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.db.jpa.entities.ListValueEntity;
import org.qubership.atp.dataset.exception.file.FileDsNotFoundException;
import org.qubership.atp.dataset.model.impl.file.FileData;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.versioning.model.domain.FileDataSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Value
public class ParameterSnapshot {
    private static final Logger log = LoggerFactory.getLogger(ParameterSnapshot.class);
    private final UUID id;
    private final UUID dataSetListId;
    private final UUID dataSetId;
    private String text;
    private AttributeTypeName type;
    private UUID dataSetReference;
    private UUID listValueId;
    private String listValueName;
    private FileDataSnapshot fileData;

    public ParameterSnapshot(Parameter model) {
        this.id = model.getId();
        this.dataSetListId = model.getDataSet().getDataSetList().getId();
        this.dataSetId = model.getDataSet().getId();
        Attribute attribute = model.getAttribute();
        if (attribute == null) {
            attribute = model.getAttributeKey().getAttribute();
        }
        this.type = attribute.getAttributeType();
        switch (this.type) {
            case ENCRYPTED: 
            case TEXT: 
            case CHANGE: {
                this.text = model.getStringValue();
                break;
            }
            case LIST: {
                ListValueEntity listValue = model.getListValue();
                if (listValue == null) break;
                this.listValueId = listValue.getId();
                this.listValueName = listValue.getText();
                break;
            }
            case DSL: {
                DataSet dataSetReferenceValue = model.getDataSetReferenceValue();
                if (dataSetReferenceValue == null) break;
                this.dataSetReference = dataSetReferenceValue.getId();
                this.text = dataSetReferenceValue.getName();
                break;
            }
            case FILE: {
                try {
                    FileData parameterFileData = model.getFileData();
                    this.fileData = parameterFileData == null ? null : new FileDataSnapshot(parameterFileData);
                }
                catch (FileDsNotFoundException e) {
                    log.debug("File variable {} not found", (Object)model.getId());
                }
                break;
            }
        }
    }

    public Object getValuePretty(ModelsProvider modelsProvider) {
        if (this.type == null) {
            return this.getValueByType();
        }
        switch (this.type) {
            case ENCRYPTED: {
                return "***********";
            }
            case CHANGE: {
                return ParameterSnapshot.getMultipleValuePretty(this.text, modelsProvider);
            }
            case LIST: {
                return this.listValueName;
            }
            case FILE: {
                return this.fileData;
            }
        }
        return this.text;
    }

    public static Object getMultipleValuePretty(String value, ModelsProvider modelsProvider) {
        if (Strings.isNullOrEmpty((String)value)) {
            return value;
        }
        String[] split = value.replaceFirst("MULTIPLY ", "").split(" ");
        LinkedList<String> result = new LinkedList<String>();
        for (String uuidString : split) {
            DataSet dataSetById = modelsProvider.getDataSetById(UUID.fromString(uuidString));
            if (dataSetById != null) {
                result.add(dataSetById.getName());
                continue;
            }
            result.add(uuidString);
        }
        return String.join((CharSequence)", ", result);
    }

    public Object getValueByType() {
        if (this.text != null) {
            return this.text;
        }
        if (this.listValueId != null) {
            return this.listValueName;
        }
        if (this.dataSetReference != null) {
            return this.dataSetReference;
        }
        if (this.fileData != null) {
            return this.fileData;
        }
        return null;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getDataSetListId() {
        return this.dataSetListId;
    }

    public UUID getDataSetId() {
        return this.dataSetId;
    }

    public String getText() {
        return this.text;
    }

    public AttributeTypeName getType() {
        return this.type;
    }

    public UUID getDataSetReference() {
        return this.dataSetReference;
    }

    public UUID getListValueId() {
        return this.listValueId;
    }

    public String getListValueName() {
        return this.listValueName;
    }

    public FileDataSnapshot getFileData() {
        return this.fileData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterSnapshot)) {
            return false;
        }
        ParameterSnapshot other = (ParameterSnapshot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        UUID this$dataSetListId = this.getDataSetListId();
        UUID other$dataSetListId = other.getDataSetListId();
        if (this$dataSetListId == null ? other$dataSetListId != null : !((Object)this$dataSetListId).equals(other$dataSetListId)) {
            return false;
        }
        UUID this$dataSetId = this.getDataSetId();
        UUID other$dataSetId = other.getDataSetId();
        if (this$dataSetId == null ? other$dataSetId != null : !((Object)this$dataSetId).equals(other$dataSetId)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        AttributeTypeName this$type = this.getType();
        AttributeTypeName other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        UUID this$dataSetReference = this.getDataSetReference();
        UUID other$dataSetReference = other.getDataSetReference();
        if (this$dataSetReference == null ? other$dataSetReference != null : !((Object)this$dataSetReference).equals(other$dataSetReference)) {
            return false;
        }
        UUID this$listValueId = this.getListValueId();
        UUID other$listValueId = other.getListValueId();
        if (this$listValueId == null ? other$listValueId != null : !((Object)this$listValueId).equals(other$listValueId)) {
            return false;
        }
        String this$listValueName = this.getListValueName();
        String other$listValueName = other.getListValueName();
        if (this$listValueName == null ? other$listValueName != null : !this$listValueName.equals(other$listValueName)) {
            return false;
        }
        FileDataSnapshot this$fileData = this.getFileData();
        FileDataSnapshot other$fileData = other.getFileData();
        return !(this$fileData == null ? other$fileData != null : !((Object)this$fileData).equals(other$fileData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterSnapshot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        UUID $dataSetListId = this.getDataSetListId();
        result = result * 59 + ($dataSetListId == null ? 43 : ((Object)$dataSetListId).hashCode());
        UUID $dataSetId = this.getDataSetId();
        result = result * 59 + ($dataSetId == null ? 43 : ((Object)$dataSetId).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        AttributeTypeName $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        UUID $dataSetReference = this.getDataSetReference();
        result = result * 59 + ($dataSetReference == null ? 43 : ((Object)$dataSetReference).hashCode());
        UUID $listValueId = this.getListValueId();
        result = result * 59 + ($listValueId == null ? 43 : ((Object)$listValueId).hashCode());
        String $listValueName = this.getListValueName();
        result = result * 59 + ($listValueName == null ? 43 : $listValueName.hashCode());
        FileDataSnapshot $fileData = this.getFileData();
        result = result * 59 + ($fileData == null ? 43 : ((Object)$fileData).hashCode());
        return result;
    }

    public String toString() {
        return "ParameterSnapshot(id=" + this.getId() + ", dataSetListId=" + this.getDataSetListId() + ", dataSetId=" + this.getDataSetId() + ", text=" + this.getText() + ", type=" + (Object)((Object)this.getType()) + ", dataSetReference=" + this.getDataSetReference() + ", listValueId=" + this.getListValueId() + ", listValueName=" + this.getListValueName() + ", fileData=" + this.getFileData() + ")";
    }
}

