/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.javers.core.metamodel.annotation.Entity;
import org.javers.core.metamodel.annotation.Id;
import org.javers.core.metamodel.annotation.TypeName;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.versioning.model.domain.AttributeSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.ListValueSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.ParameterSnapshot;
import org.qubership.atp.dataset.versioning.service.changes.ParameterComparable;

@Entity
@TypeName(value="Attribute")
public class AttributeComparable {
    @Id
    private final UUID id;
    private final String name;
    private final AttributeTypeName type;
    private final Set<ParameterComparable> parameters = new HashSet<ParameterComparable>();
    private final Set<ListValueSnapshot> listValues = new HashSet<ListValueSnapshot>();

    public AttributeComparable(AttributeSnapshot snapshot) {
        this.id = snapshot.getId();
        this.name = snapshot.getName();
        this.type = snapshot.getType();
        for (ParameterSnapshot parameter : snapshot.getParameters()) {
            this.parameters.add(new ParameterComparable(this.name, parameter));
        }
        this.listValues.addAll(snapshot.getListValues());
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public AttributeTypeName getType() {
        return this.type;
    }

    public Set<ParameterComparable> getParameters() {
        return this.parameters;
    }

    public Set<ListValueSnapshot> getListValues() {
        return this.listValues;
    }

    public String toString() {
        return "AttributeComparable(id=" + this.getId() + ", name=" + this.getName() + ", type=" + (Object)((Object)this.getType()) + ", parameters=" + this.getParameters() + ", listValues=" + this.getListValues() + ")";
    }
}

