/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.PropertyChange;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.model.domain.ListValueSnapshot;
import org.qubership.atp.dataset.versioning.model.domain.ParameterSnapshot;
import org.qubership.atp.dataset.versioning.service.changes.AttributeComparable;
import org.qubership.atp.dataset.versioning.service.changes.AttributeKeyComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.ParameterComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.ChangeProcessor;

public abstract class AbstractChangeProcessor
implements ChangeProcessor {
    protected ChangeProcessor nextProcessor;

    static DataSetComparable getDataSetById(DataSetListComparable dataSetList, UUID dataSetId) {
        return dataSetList.getDataSets().stream().filter(dataSet -> dataSet.getId().equals(dataSetId)).findFirst().get();
    }

    static AttributeComparable getAttributeById(DataSetListComparable dataSetList, UUID attributeId) {
        for (AttributeComparable attribute : dataSetList.getAttributes()) {
            if (!attribute.getId().equals(attributeId)) continue;
            return attribute;
        }
        return null;
    }

    static ParameterComparable getParameterById(DataSetListComparable dataSetList, UUID parameterId) {
        return dataSetList.getAttributes().stream().flatMap(attribute -> attribute.getParameters().stream()).filter(parameter -> parameter.getId().equals(parameterId)).findFirst().get();
    }

    static <T extends Change> List<T> filterChangesByTypeAndAffectedType(Diff diff, Class<T> changeType, String affectedType) {
        ArrayList<Change> list = new ArrayList<Change>();
        for (Change change : diff.getChangesByType(changeType)) {
            if (!affectedType.equals(change.getAffectedGlobalId().getTypeName())) continue;
            list.add(change);
        }
        return list;
    }

    static <T extends PropertyChange> List<T> filterChangesByTypeAndProperty(Diff diff, Class<T> changeType, String propertyName) {
        ArrayList<PropertyChange> result = new ArrayList<PropertyChange>();
        for (PropertyChange propertyChange : diff.getChangesByType(changeType)) {
            if (!propertyName.equals(propertyChange.getPropertyName())) continue;
            result.add(propertyChange);
        }
        return result;
    }

    static List<ParameterComparable> findOverlappedParametersByChangeType(Diff diff, Class<? extends Change> changeType) {
        ArrayList<ParameterComparable> list = new ArrayList<ParameterComparable>();
        for (Change change : AbstractChangeProcessor.filterChangesByTypeAndAffectedType(diff, changeType, "AttributeKey")) {
            AttributeKeyComparable attributeKey = (AttributeKeyComparable)change.getAffectedObject().get();
            ParameterComparable parameter = new ParameterComparable(attributeKey.getAttributePathNames(), attributeKey.getParameter());
            list.add(parameter);
        }
        return list;
    }

    static String getAttributeDeepNameByParameter(Set<AttributeComparable> attributes, ParameterComparable parameter) {
        for (AttributeComparable attribute : attributes) {
            if (!attribute.getParameters().stream().anyMatch(param -> param.equals(parameter))) continue;
            return attribute.getName();
        }
        return null;
    }

    static String convertListValuesToString(AttributeComparable attribute) {
        return attribute.getListValues().stream().map(ListValueSnapshot::getName).sorted().collect(Collectors.joining(", "));
    }

    static <T extends PropertyChange> List<T> filterChangesByTypeAndAffectedTypeAndProperty(Diff diff, Class<T> changeType, String affectedType, String propertyName) {
        ArrayList<PropertyChange> list = new ArrayList<PropertyChange>();
        for (PropertyChange propertyChange : diff.getChangesByType(changeType)) {
            if (!affectedType.equals(propertyChange.getAffectedGlobalId().getTypeName()) || !propertyName.equals(propertyChange.getPropertyName())) continue;
            list.add(propertyChange);
        }
        return list;
    }

    @Override
    public HistoryItemDto proceed(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        if (this.isApplicable(diff, actualEntity)) {
            return this.createHistoryItem(diff, oldEntity, actualEntity);
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.proceed(diff, oldEntity, actualEntity);
        }
        return null;
    }

    protected abstract boolean isApplicable(Diff var1, DataSetListComparable var2);

    protected abstract HistoryItemDto createHistoryItem(Diff var1, DataSetListComparable var2, DataSetListComparable var3);

    public String getValuePretty(String value, AttributeTypeName typeName, ModelsProvider modelsProvider) {
        if (typeName == null) {
            return value;
        }
        switch (typeName) {
            case CHANGE: {
                return ParameterSnapshot.getMultipleValuePretty(value, modelsProvider).toString();
            }
            case ENCRYPTED: {
                return "**********";
            }
        }
        return value;
    }

    @Override
    public void setNextProcessor(ChangeProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }
}

