/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.DataSetComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=7)
public class DeleteDataSetProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(DeleteDataSetProcessor.class);

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<ObjectRemoved> removedDataSets = DeleteDataSetProcessor.filterChangesByTypeAndAffectedType(diff, ObjectRemoved.class, "DataSet");
        return !removedDataSets.isEmpty();
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        ObjectRemoved dataSetRemoved = DeleteDataSetProcessor.filterChangesByTypeAndAffectedType(diff, ObjectRemoved.class, "DataSet").get(0);
        String dataSetName = ((DataSetComparable)dataSetRemoved.getAffectedObject().get()).getName();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.DELETED.toString());
        historyItem.setDataSet(dataSetName);
        log.trace("Diff processed by DeleteDataSetChangeProcessor");
        return historyItem;
    }
}

