/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.NewObject;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.javers.core.diff.changetype.ValueChange;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.ParameterComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=5)
public class DeleteParameterProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(DeleteParameterProcessor.class);

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<ObjectRemoved> removedParameters = DeleteParameterProcessor.filterChangesByTypeAndAffectedType(diff, ObjectRemoved.class, "Parameter");
        List<ParameterComparable> newOverlappedParameters = DeleteParameterProcessor.findOverlappedParametersByChangeType(diff, NewObject.class);
        List<ObjectRemoved> removedDataSets = DeleteParameterProcessor.filterChangesByTypeAndAffectedType(diff, ObjectRemoved.class, "DataSet");
        List<ObjectRemoved> removedAttributes = DeleteParameterProcessor.filterChangesByTypeAndAffectedType(diff, ObjectRemoved.class, "Attribute");
        List<ValueChange> valueChanges = DeleteParameterProcessor.filterChangesByTypeAndProperty(diff, ValueChange.class, "value");
        return !removedParameters.isEmpty() && newOverlappedParameters.isEmpty() && removedDataSets.isEmpty() && removedAttributes.isEmpty() && valueChanges.isEmpty();
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        ObjectRemoved removedParameter = DeleteParameterProcessor.filterChangesByTypeAndAffectedType(diff, ObjectRemoved.class, "Parameter").get(0);
        ParameterComparable parameter = (ParameterComparable)removedParameter.getAffectedObject().get();
        String attributeName = DeleteParameterProcessor.getAttributeDeepNameByParameter(oldEntity.getAttributes(), parameter);
        String dataSetName = DeleteParameterProcessor.getDataSetById(actualEntity, parameter.getDataSet()).getName();
        String value = parameter.getValue().toString();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.DELETED.toString());
        historyItem.setAttribute(attributeName);
        historyItem.setDataSet(dataSetName);
        historyItem.setOldValue(value);
        log.trace("Diff processed by DeleteParameterChangeProcessor");
        return historyItem;
    }
}

