/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ValueChange;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.DataSetComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=13)
public class LockedDataSetProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(LockedDataSetProcessor.class);

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<ValueChange> dataSetNameChanges = LockedDataSetProcessor.filterChangesByTypeAndAffectedTypeAndProperty(diff, ValueChange.class, "DataSet", "locked");
        return !dataSetNameChanges.isEmpty();
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        ValueChange dataSetLockedChange = LockedDataSetProcessor.filterChangesByTypeAndAffectedTypeAndProperty(diff, ValueChange.class, "DataSet", "locked").get(0);
        DataSetComparable dataset = (DataSetComparable)dataSetLockedChange.getAffectedObject().get();
        String dataSetName = dataset.getName();
        boolean oldValue = LockedDataSetProcessor.getDataSetById(oldEntity, dataset.getId()).getLocked();
        String oldValueStr = oldValue ? "Locked" : "Unlocked";
        String newValueStr = oldValue ? "Unlocked" : "Locked";
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.CHANGED.toString());
        historyItem.setDataSet(dataSetName);
        historyItem.setOldValue(oldValueStr);
        historyItem.setNewValue(newValueStr);
        log.trace("Diff processed by LockedDataSetProcessor");
        return historyItem;
    }
}

