/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ValueChange;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.AttributeComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=8)
public class RenamedAttributeProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(RenamedAttributeProcessor.class);

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<ValueChange> attributeNameChanges = RenamedAttributeProcessor.filterChangesByTypeAndAffectedTypeAndProperty(diff, ValueChange.class, "Attribute", "name");
        return !attributeNameChanges.isEmpty();
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        ValueChange attributeNameChange = RenamedAttributeProcessor.filterChangesByTypeAndAffectedTypeAndProperty(diff, ValueChange.class, "Attribute", "name").get(0);
        AttributeComparable attribute = (AttributeComparable)attributeNameChange.getAffectedObject().get();
        String attributeName = attribute.getName();
        String oldValue = RenamedAttributeProcessor.getAttributeById(oldEntity, attribute.getId()).getName();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.CHANGED.toString());
        historyItem.setAttribute(attributeName);
        historyItem.setOldValue(oldValue);
        historyItem.setNewValue(attributeName);
        log.trace("Diff processed by RenamedAttributeChangeProcessor");
        return historyItem;
    }
}

