/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.modelmapper.internal.Accessor;
import org.modelmapper.internal.ConstantMappingImpl;
import org.modelmapper.internal.Errors;
import org.modelmapper.internal.ErrorsException;
import org.modelmapper.internal.ExplicitMappingBuilder;
import org.modelmapper.internal.InheritingConfiguration;
import org.modelmapper.internal.MappingImpl;
import org.modelmapper.internal.Mutator;
import org.modelmapper.internal.PropertyInfoImpl;
import org.modelmapper.internal.PropertyInfoRegistry;
import org.modelmapper.internal.PropertyInfoResolver;
import org.modelmapper.internal.PropertyMappingImpl;
import org.modelmapper.internal.ProxyFactory;
import org.modelmapper.internal.SourceMappingImpl;
import org.modelmapper.internal.TypeInfoRegistry;
import org.modelmapper.internal.TypeMapImpl;
import org.modelmapper.spi.NameableType;
import org.modelmapper.spi.TypeSafeSourceGetter;

class PropertyReferenceCollector {
    private InheritingConfiguration config;
    private ExplicitMappingBuilder.MappingOptions options;
    private List<Accessor> accessors;
    private List<Mutator> mutators;
    private Class<?> sourceType;
    private Object constant;
    private Errors errors;
    private Errors proxyErrors;

    public static <S, D> List<Accessor> collect(TypeMapImpl<S, D> typeMap, TypeSafeSourceGetter<S, ?> sourceGetter) {
        PropertyReferenceCollector collector = new PropertyReferenceCollector(typeMap.configuration, null);
        try {
            S source = ProxyFactory.proxyFor(typeMap.getSourceType(), collector.newSourceInterceptor(), collector.getProxyErrors());
            Object sourceProperty = sourceGetter.get(source);
            if (source == sourceProperty) {
                collector.mapFromSource(typeMap.getSourceType());
            }
            if (collector.isNoSourceGetter()) {
                collector.mapFromConstant(sourceProperty);
            }
        }
        catch (NullPointerException e) {
            if (collector.getProxyErrors().hasErrors()) {
                throw collector.getProxyErrors().toException();
            }
            throw e;
        }
        catch (ErrorsException e) {
            throw e.getErrors().toConfigurationException();
        }
        return collector.accessors;
    }

    PropertyReferenceCollector(InheritingConfiguration config, ExplicitMappingBuilder.MappingOptions options) {
        this.config = config;
        this.options = options;
        this.accessors = new ArrayList<Accessor>();
        this.mutators = new ArrayList<Mutator>();
        this.errors = new Errors();
        this.proxyErrors = new Errors();
    }

    private static Class<?> resolveReturnType(Method method) {
        PropertyInfoImpl.MethodAccessor accessor = new PropertyInfoImpl.MethodAccessor(method.getDeclaringClass(), method, method.getName());
        return accessor.getType();
    }

    SourceInterceptor newSourceInterceptor() {
        return new SourceInterceptor();
    }

    DestinationInterceptor newDestinationInterceptor() {
        return new DestinationInterceptor();
    }

    private void visitSource(Class<?> type, Method method) {
        if (PropertyInfoResolver.ACCESSORS.isValid(method)) {
            String propertyName = this.config.getSourceNameTransformer().transform(method.getName(), NameableType.METHOD);
            this.accessors.add(PropertyInfoRegistry.accessorFor(type, method, this.config, propertyName));
        } else {
            this.errors.addMessage("Illegal SourceGetter method: %s.%s", type.getName(), method.getName());
        }
    }

    private void visitDestination(Class<?> type, Method method) {
        if (PropertyInfoResolver.MUTATORS.isValid(method)) {
            String propertyName = this.config.getDestinationNameTransformer().transform(method.getName(), NameableType.METHOD);
            this.mutators.add(PropertyInfoRegistry.mutatorFor(type, method, this.config, propertyName));
        } else if (PropertyInfoResolver.ACCESSORS.isValid(method)) {
            Mutator mutator = TypeInfoRegistry.typeInfoFor(type, this.config).mutatorForAccessorMethod(method.getName());
            if (mutator != null) {
                this.mutators.add(mutator);
            } else {
                this.errors.addMessage("No setter found: %s.%s", type.getName(), method.getName());
            }
        } else {
            this.errors.addMessage("Illegal DestinationSetter method: %s.%s", type.getName(), method.getName());
        }
    }

    MappingImpl collect() {
        if (this.mutators.isEmpty()) {
            this.errors.addMessage("Illegal DestinationSetter defined", new Object[0]);
        }
        this.errors.throwConfigurationExceptionIfErrorsExist();
        if (this.sourceType != null) {
            return new SourceMappingImpl(this.sourceType, this.mutators, this.options);
        }
        if (this.accessors.isEmpty()) {
            return new ConstantMappingImpl(this.constant, this.mutators, this.options);
        }
        return new PropertyMappingImpl(this.accessors, this.mutators, this.options);
    }

    public Errors getErrors() {
        return this.errors;
    }

    Errors getProxyErrors() {
        return this.proxyErrors;
    }

    void mapFromSource(Class<?> sourceType) {
        this.sourceType = sourceType;
    }

    void mapFromConstant(Object constant) {
        this.constant = constant;
    }

    boolean isNoSourceGetter() {
        return this.accessors.isEmpty();
    }

    public final class DestinationInterceptor
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            PropertyReferenceCollector.this.visitDestination(proxy.getClass(), method);
            if (Void.class.isAssignableFrom(method.getReturnType())) {
                return null;
            }
            try {
                return ProxyFactory.proxyFor(PropertyReferenceCollector.resolveReturnType(method), this, PropertyReferenceCollector.this.proxyErrors);
            }
            catch (ErrorsException e) {
                return null;
            }
        }
    }

    public final class SourceInterceptor
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            PropertyReferenceCollector.this.visitSource(proxy.getClass(), method);
            if (Void.class.isAssignableFrom(method.getReturnType())) {
                return null;
            }
            try {
                return ProxyFactory.proxyFor(PropertyReferenceCollector.resolveReturnType(method), this, PropertyReferenceCollector.this.proxyErrors);
            }
            catch (ErrorsException e) {
                return null;
            }
        }
    }
}

