/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.servlet;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.http.HttpServerRequest;
import org.springframework.cloud.sleuth.http.HttpServerResponse;
import org.springframework.cloud.sleuth.instrument.web.servlet.HttpServletRequestWrapper;
import org.springframework.cloud.sleuth.instrument.web.servlet.HttpServletResponseWrapper;
import org.springframework.cloud.sleuth.instrument.web.servlet.ServletRuntime;

public final class TracingFilter
implements Filter {
    final ServletRuntime servlet = ServletRuntime.get();
    final CurrentTraceContext currentTraceContext;
    final HttpServerHandler handler;

    public static TracingFilter create(CurrentTraceContext currentTraceContext, HttpServerHandler httpServerHandler) {
        return new TracingFilter(currentTraceContext, httpServerHandler);
    }

    TracingFilter(CurrentTraceContext currentTraceContext, HttpServerHandler httpServerHandler) {
        this.currentTraceContext = currentTraceContext;
        this.handler = httpServerHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = this.servlet.httpServletResponse(response);
        TraceContext context = (TraceContext)request.getAttribute(TraceContext.class.getName());
        if (context != null) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(context);){
                chain.doFilter(request, response);
            }
            return;
        }
        Span span = this.handler.handleReceive((HttpServerRequest)new HttpServletRequestWrapper(req));
        request.setAttribute(SpanCustomizer.class.getName(), (Object)span);
        request.setAttribute(TraceContext.class.getName(), (Object)span.context());
        SendHandled sendHandled = new SendHandled();
        request.setAttribute(SendHandled.class.getName(), (Object)sendHandled);
        Throwable error = null;
        CurrentTraceContext.Scope scope = this.currentTraceContext.newScope(span.context());
        try {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
        catch (Throwable e) {
            error = e;
            throw e;
        }
        finally {
            if (this.servlet.isAsync(req)) {
                this.servlet.handleAsync(this.handler, req, res, span);
            } else if (sendHandled.compareAndSet(false, true)) {
                HttpServerResponse responseWrapper = HttpServletResponseWrapper.create(req, res, error);
                this.handler.handleSend(responseWrapper, span);
            }
            scope.close();
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) {
    }

    static final class SendHandled
    extends AtomicBoolean {
        SendHandled() {
        }
    }
}

