/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.utils;

import java.util.function.Supplier;

public class MutableSupplier<T>
implements Supplier<T> {
    private boolean valueWasSet;
    private T value;

    private MutableSupplier() {
    }

    public static <T> MutableSupplier<T> create() {
        return new MutableSupplier<T>();
    }

    @Override
    public T get() {
        if (!this.valueWasSet) {
            throw new NullPointerException("Value has not been set yet");
        }
        return this.value;
    }

    public T set(T value) {
        if (this.valueWasSet) {
            throw new IllegalStateException("Value has already been set and should not be reset");
        }
        this.value = value;
        this.valueWasSet = true;
        return value;
    }
}

