/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset;

import org.qubership.atp.auth.springbootstarter.security.oauth2.client.config.annotation.EnableOauth2FeignClientInterceptor;
import org.qubership.atp.common.lock.annotation.EnableAtpLockManager;
import org.qubership.atp.common.probes.annotation.EnableProbes;
import org.qubership.atp.crypt.config.annotation.AtpCryptoEnable;
import org.qubership.atp.crypt.config.annotation.AtpDecryptorEnable;
import org.qubership.atp.dataset.config.AtpSwaggerConfig;
import org.qubership.atp.dataset.config.CacheConfiguration;
import org.qubership.atp.dataset.config.ConverterConfig;
import org.qubership.atp.dataset.config.DsSecurityConfiguration;
import org.qubership.atp.dataset.config.ExportNodeConfiguration;
import org.qubership.atp.dataset.config.HttpsConfig;
import org.qubership.atp.dataset.config.KafkaConfiguration;
import org.qubership.atp.dataset.config.LocaleResolverConfiguration;
import org.qubership.atp.dataset.config.ServiceConfiguration;
import org.qubership.atp.dataset.config.SpringLiquibaseConfig;
import org.qubership.atp.dataset.db.migration.MigrationRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.annotation.EnableAsync;

@Import(value={ServiceConfiguration.class, HttpsConfig.class, DsSecurityConfiguration.class, ConverterConfig.class, KafkaConfiguration.class, ExportNodeConfiguration.class, AtpSwaggerConfig.class, LocaleResolverConfiguration.class, SpringLiquibaseConfig.class, CacheConfiguration.class})
@SpringBootConfiguration
@EnableAutoConfiguration(exclude={MongoAutoConfiguration.class})
@AtpCryptoEnable
@AtpDecryptorEnable
@EnableFeignClients(basePackages={"org.qubership.atp.integration.configuration.feign", "org.qubership.atp.macros.core", "org.qubership.atp.dataset"})
@EnableOauth2FeignClientInterceptor
@EnableDiscoveryClient
@EnableAsync
@EnableAtpLockManager
@EnableProbes
public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);

    public static void main(String[] args) {
        ConfigurableApplicationContext configurableApplicationContext = SpringApplication.run(Main.class, (String[])args);
        configurableApplicationContext.addApplicationListener((ApplicationListener)new ApplicationPidFileWriter("application.pid"));
        MigrationRunner migrationRunner = (MigrationRunner)configurableApplicationContext.getBean(MigrationRunner.class);
        migrationRunner.runMigration();
    }
}

