/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.config.interceptors;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.qubership.atp.dataset.db.CacheRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="dsCacheInterceptor")
public class CacheInterceptor {
    @Autowired
    private CacheRepository cacheRepo;

    @Around(value="within(org.qubership.atp.dataset.service.direct.IdentifiedService+) && ! @annotation(org.springframework.transaction.annotation.Transactional)")
    public Object invoke(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            this.cacheRepo.enableCache();
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            this.cacheRepo.disableCache();
        }
    }
}

