/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.db;

import com.google.common.base.Preconditions;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.MappingProjection;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.db.AbstractRepository;
import org.qubership.atp.dataset.model.Label;
import org.qubership.atp.dataset.model.impl.LabelImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class LabelRepository
extends AbstractRepository {
    private final LabelProjection projection;
    private final SQLQueryFactory queryFactory;

    @Autowired
    public LabelRepository(@Nonnull SQLQueryFactory queryFactory) {
        this.queryFactory = queryFactory;
        this.projection = new LabelProjection();
    }

    @Nonnull
    private Label getByNameOrCreate(String name) {
        Label label = this.getLabelByName(name);
        if (label != null) {
            return label;
        }
        UUID id = (UUID)((SQLInsertClause)this.queryFactory.insert((RelationalPath)LABEL).set((Path)LabelRepository.LABEL.name, (Object)name)).executeWithKey(LabelRepository.LABEL.id);
        Preconditions.checkNotNull((Object)id, (Object)"nothing created");
        return new LabelImpl(id, name);
    }

    @Nonnull
    Label markDsl(@Nonnull UUID dataSetListId, @Nonnull String labelName) {
        return this.mark(DSLLABEL, LabelRepository.DSLLABEL.datasetlistId, dataSetListId, LabelRepository.DSLLABEL.labelId, labelName);
    }

    @Nonnull
    Label markDs(@Nonnull UUID dataSetId, @Nonnull String labelName) {
        return this.mark(DSLABEL, LabelRepository.DSLABEL.datasetId, dataSetId, LabelRepository.DSLABEL.labelId, labelName);
    }

    @Nonnull
    List<Label> getLabelsOfDsl(@Nonnull UUID dslId) {
        return this.getLabels(DSLLABEL, LabelRepository.DSLLABEL.labelId, (Predicate)LabelRepository.DSLLABEL.datasetlistId.eq((Object)dslId));
    }

    @Nullable
    public Label getLabelByName(@Nonnull String name) {
        return (Label)((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)LABEL)).where((Predicate)LabelRepository.LABEL.name.eq((Object)name))).fetchOne();
    }

    @Nonnull
    List<Label> getLabelsOfDs(@Nonnull UUID dsId) {
        return this.getLabels(DSLABEL, LabelRepository.DSLABEL.labelId, (Predicate)LabelRepository.DSLABEL.datasetId.eq((Object)dsId));
    }

    boolean unmarkDsl(@Nonnull UUID dslId, @Nonnull UUID labelId) {
        return this.delete(DSLLABEL, (Predicate)LabelRepository.DSLLABEL.datasetlistId.eq((Object)dslId).and((Predicate)LabelRepository.DSLLABEL.labelId.eq((Object)labelId))) > 0L;
    }

    boolean unmarkDs(@Nonnull UUID dsId, @Nonnull UUID labelId) {
        return this.delete(DSLABEL, (Predicate)LabelRepository.DSLABEL.datasetId.eq((Object)dsId).and((Predicate)LabelRepository.DSLABEL.labelId.eq((Object)labelId))) > 0L;
    }

    void onDslDeleteCascade(@Nonnull UUID dslId) {
        this.delete(DSLLABEL, (Predicate)LabelRepository.DSLLABEL.datasetlistId.eq((Object)dslId));
    }

    void onDsDeleteCascade(@Nonnull UUID dsId) {
        this.delete(DSLABEL, (Predicate)LabelRepository.DSLABEL.datasetId.eq((Object)dsId));
    }

    private long delete(@Nonnull RelationalPathBase table, @Nonnull Predicate predicate) {
        return ((SQLDeleteClause)this.queryFactory.delete((RelationalPath)table).where(predicate)).execute();
    }

    private Label mark(@Nonnull RelationalPathBase table, @Nonnull SimplePath<UUID> idColumn, @Nonnull UUID id, @Nonnull SimplePath<UUID> labelColumn, @Nonnull String labelName) {
        Label label = this.getByNameOrCreate(labelName);
        ((SQLInsertClause)((SQLInsertClause)this.queryFactory.insert((RelationalPath)table).set(idColumn, (Object)id)).set(labelColumn, (Object)label.getId())).execute();
        return label;
    }

    BooleanExpression dslByLabelName(@Nonnull String labelName) {
        return LabelRepository.DSL.id.in((SubQueryExpression)((SQLQuery)this.queryFactory.select(LabelRepository.DSLLABEL.datasetlistId).from((Expression)DSLLABEL)).where((Predicate)LabelRepository.DSLLABEL.labelId.eq((Expression)((SQLQuery)this.queryFactory.select(LabelRepository.LABEL.id).from((Expression)LABEL)).where((Predicate)LabelRepository.LABEL.name.eq((Object)labelName)))));
    }

    BooleanExpression dsByLabelName(@Nonnull String labelName) {
        return LabelRepository.DS.id.in((SubQueryExpression)((SQLQuery)this.queryFactory.select(LabelRepository.DSLABEL.datasetId).from((Expression)DSLABEL)).where((Predicate)LabelRepository.DSLABEL.labelId.eq((Expression)((SQLQuery)this.queryFactory.select(LabelRepository.LABEL.id).from((Expression)LABEL)).where((Predicate)LabelRepository.LABEL.name.eq((Object)labelName)))));
    }

    private List<Label> getLabels(@Nonnull RelationalPathBase table, @Nonnull SimplePath<UUID> labelColumn, @Nonnull Predicate predicate) {
        return ((SQLQuery)((SQLQuery)this.queryFactory.select((Expression)this.projection).from((Expression)LABEL)).where((Predicate)LabelRepository.LABEL.id.in((Collection)((SQLQuery)((SQLQuery)this.queryFactory.select(labelColumn).from((Expression)table)).where(predicate)).fetch()))).fetch();
    }

    private class LabelProjection
    extends MappingProjection<Label> {
        LabelProjection() {
            super(Label.class, (Expression[])AbstractRepository.LABEL.all());
        }

        protected LabelImpl map(Tuple row) {
            UUID id = (UUID)row.get(AbstractRepository.LABEL.id);
            assert (id != null);
            String name = (String)row.get((Expression)AbstractRepository.LABEL.name);
            assert (name != null);
            return new LabelImpl(id, name);
        }
    }
}

