/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.macros.args;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.macros.EvaluationContext;
import org.qubership.atp.dataset.macros.args.ArgSignature;
import org.qubership.atp.dataset.macros.args.CtxValueSup;
import org.qubership.atp.dataset.macros.args.MacroArg;
import org.qubership.atp.dataset.macros.args.SigValueSup;
import org.qubership.atp.dataset.macros.args.SignatureArg;
import org.qubership.atp.dataset.macros.impl.reference.ReferenceAliasType;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.DataSet;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.Named;
import org.qubership.atp.dataset.model.VisibilityArea;

public abstract class RefArg<T extends Named & Identified>
implements MacroArg {
    protected final ReferenceAliasType<T> refType;
    protected String text;
    protected T instance = null;

    protected RefArg(@Nonnull ReferenceAliasType<T> refType, @Nonnull String text) {
        this.refType = refType;
        this.text = text;
    }

    public static <T extends Named & Identified> Signature<T> of(@Nonnull ReferenceAliasType<T> refType, @Nonnull ArgSignature signature, @Nonnull SigValueSup<? extends T> valueSup) {
        return new Signature(refType, signature, valueSup);
    }

    public static <T extends Named & Identified> Context<T> of(@Nonnull ReferenceAliasType<T> refType, @Nonnull CtxValueSup<? extends T> valueSup) {
        return new Context(refType, valueSup);
    }

    public static <T extends Named & Identified> Context<T> of(@Nonnull ReferenceAliasType<T> refType, @Nonnull T instance) {
        Context<T> result = new Context<T>(refType, CtxValueSup.ofInstance(refType, instance));
        result.resolve(instance);
        return result;
    }

    @Nonnull
    public ReferenceAliasType<T> getType() {
        return this.refType;
    }

    public Optional<? extends RefArg<DataSetList>> asDsl() {
        if (ReferenceAliasType.DSL == this.refType) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public Optional<? extends RefArg<DataSet>> asDs() {
        if (ReferenceAliasType.DS == this.refType) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public Optional<? extends RefArg<Attribute>> asAttr() {
        if (ReferenceAliasType.ATTR == this.refType) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public Optional<Signature<T>> asSignature() {
        return Optional.empty();
    }

    public Optional<Context<T>> asContextRef() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public String getText() {
        return this.text;
    }

    public void setText(@Nonnull String text) {
        this.text = text;
    }

    public void resolve(@Nullable T value) {
        this.instance = value;
    }

    public boolean isResolved() {
        return this.instance != null;
    }

    @Nonnull
    public T get() {
        Preconditions.checkState((boolean)this.isResolved(), (Object)("Not resolved: " + this));
        return this.instance;
    }

    public String toString() {
        return "<" + this.refType + " with value " + (this.instance == null ? this.text : this.instance.toString()) + ">";
    }

    public static class Signature<T extends Identified & Named>
    extends RefArg<T>
    implements Supplier<T>,
    SignatureArg {
        private final ArgSignature signature;
        private final SigValueSup<? extends T> valueSup;

        private Signature(@Nonnull ReferenceAliasType<T> refType, @Nonnull ArgSignature signature, @Nonnull SigValueSup<? extends T> valueSup) {
            super(refType, signature.getSource());
            this.signature = signature;
            this.valueSup = valueSup;
        }

        @Override
        public Optional<Signature<T>> asSignature() {
            return Optional.of(this);
        }

        @Nonnull
        public T resolve(@Nonnull List<? extends MacroArg> previousArgs, @Nonnull VisibilityArea contextVa, @Nonnull DataSetList contextDsl) throws Exception {
            Identified instance = (Identified)this.valueSup.get(previousArgs, this.text, contextVa, contextDsl);
            this.resolve(instance);
            return (T)instance;
        }

        @Override
        public String toString() {
            return "<" + this.valueSup + " with value " + (this.instance == null ? this.text : ((Identified)((Object)this.instance)).toString()) + ">";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Signature refArg = (Signature)o;
            return Objects.equals(this.refType, refArg.refType) && Objects.equals(this.signature, refArg.signature);
        }

        public int hashCode() {
            return Objects.hash(this.refType, this.signature);
        }

        public Optional<Signature<T>> asRef() {
            return Optional.of(this);
        }

        @Override
        @Nonnull
        public ArgSignature getSignature() {
            return this.signature;
        }

        @Override
        public Optional<Signature<DataSetList>> asDsl() {
            if (ReferenceAliasType.DSL == this.refType) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<Signature<DataSet>> asDs() {
            if (ReferenceAliasType.DS == this.refType) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<Signature<Attribute>> asAttr() {
            if (ReferenceAliasType.ATTR == this.refType) {
                return Optional.of(this);
            }
            return Optional.empty();
        }
    }

    public static class Context<T extends Identified & Named>
    extends RefArg<T> {
        private final CtxValueSup<? extends T> valueSup;

        private Context(@Nonnull ReferenceAliasType<T> refType, @Nonnull CtxValueSup<? extends T> valueSup) {
            super(refType, valueSup.toString());
            this.valueSup = valueSup;
        }

        @Nonnull
        public T resolve(@Nonnull EvaluationContext context) {
            Identified result = (Identified)this.valueSup.get(context);
            this.resolve(result);
            return (T)result;
        }

        @Override
        public Optional<Context<T>> asContextRef() {
            return Optional.of(this);
        }

        @Override
        public Optional<Context<DataSetList>> asDsl() {
            if (ReferenceAliasType.DSL == this.refType) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<Context<DataSet>> asDs() {
            if (ReferenceAliasType.DS == this.refType) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<Context<Attribute>> asAttr() {
            if (ReferenceAliasType.ATTR == this.refType) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Context refArg = (Context)o;
            return Objects.equals(this.refType, refArg.refType) && Objects.equals(this.valueSup, refArg.valueSup);
        }

        public int hashCode() {
            return Objects.hash(this.refType, this.valueSup);
        }

        @Override
        public Optional<? extends RefArg<?>> asRef() {
            return Optional.of(this);
        }

        @Override
        public String toString() {
            return "<" + this.valueSup + " with value " + (this.instance == null ? this.text : ((Identified)((Object)this.instance)).toString()) + ">";
        }
    }
}

