/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.impl;

import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.qubership.atp.dataset.model.Attribute;
import org.qubership.atp.dataset.model.AttributeType;
import org.qubership.atp.dataset.model.DataSetList;
import org.qubership.atp.dataset.model.Identified;
import org.qubership.atp.dataset.model.ListValue;
import org.qubership.atp.dataset.model.Parameter;
import org.qubership.atp.dataset.model.impl.AbstractNamed;

public class AttributeImpl
extends AbstractNamed
implements Attribute {
    private DataSetList dataSetList;
    private AttributeType type;
    private DataSetList dataSetListReference;
    private List<Parameter> parameters;
    private List<ListValue> listValues;

    public AttributeImpl() {
    }

    public AttributeImpl(UUID id, String name, DataSetList dataSetList, AttributeType type, DataSetList dataSetListReference, List<ListValue> listValues, List<Parameter> parameters) {
        this.id = id;
        this.name = name;
        this.dataSetList = dataSetList;
        this.type = type;
        this.dataSetListReference = dataSetListReference;
        this.parameters = parameters;
        this.listValues = listValues;
    }

    @Override
    @Nonnull
    public Stream<Identified> getReferences() {
        Stream<Identified> result = Stream.of(this.getDataSetList(), this.getDataSetListReference());
        if (this.getParameters() != null) {
            result = Stream.concat(result, this.getParameters().stream());
        }
        if (this.getListValues() != null) {
            result = Stream.concat(result, this.getListValues().stream());
        }
        return result;
    }

    @Override
    public DataSetList getDataSetList() {
        return this.dataSetList;
    }

    @Override
    public void setDataSetList(DataSetList dataSetList) {
        this.dataSetList = dataSetList;
    }

    @Override
    public AttributeType getType() {
        return this.type;
    }

    @Override
    public void setType(AttributeType type) {
        this.type = type;
    }

    @Override
    public DataSetList getDataSetListReference() {
        return this.dataSetListReference;
    }

    @Override
    public void setDataSetListReference(DataSetList list) {
        this.dataSetListReference = list;
    }

    @Override
    public List<ListValue> getListValues() {
        return this.listValues;
    }

    @Override
    public void setListValues(List<ListValue> listValues) {
        this.listValues = listValues;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }
}

