/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.model.utils.tree;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.qubership.atp.dataset.model.utils.tree.LeafsDetector;
import org.qubership.atp.dataset.model.utils.tree.TraverseAndLeafsHandler;

public class LeafsWalker<I, O, L>
extends AbstractIterator<L> {
    private final LeafsDetector<I, O, Object> leafsSup;
    private L leaf;

    public LeafsWalker(@Nonnull Iterator<? extends I> parents, @Nonnull TraverseAndLeafsHandler<I, O, L> traverseHandler, @Nullable Predicate<Object> itemsFilter) {
        this.leafsSup = new LeafsDetector<I, O, Object>(parents, traverseHandler, itemsFilter){

            @Override
            @Nullable
            protected Iterator<? extends O> getChildren(@Nonnull Object parent) {
                Iterator result = super.getChildren(parent);
                if (result == null || !result.hasNext()) {
                    LeafsWalker.this.consume(parent);
                }
                return result;
            }
        };
    }

    protected L computeNext() {
        this.leaf = null;
        while (this.leaf == null && this.leafsSup.hasNext()) {
            this.leafsSup.next();
        }
        if (this.leaf == null) {
            return (L)this.endOfData();
        }
        return this.leaf;
    }

    private void consume(Object leaf) {
        Object typeSafeLeaf = leaf;
        TraverseAndLeafsHandler currentTraverseHandler = (TraverseAndLeafsHandler)this.leafsSup.currentTraverseHandler;
        this.leaf = currentTraverseHandler.constructLeaf(typeSafeLeaf);
    }
}

