/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.impl;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.dataset.db.jpa.ModelsProvider;
import org.qubership.atp.dataset.service.direct.ClearCacheService;
import org.qubership.atp.dataset.service.direct.DateAuditorService;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.JpaParameterService;
import org.qubership.atp.dataset.service.jpa.delegates.Attribute;
import org.qubership.atp.dataset.service.jpa.delegates.DataSet;
import org.qubership.atp.dataset.service.jpa.delegates.Parameter;
import org.qubership.atp.dataset.service.jpa.model.AttributeTypeName;
import org.qubership.atp.dataset.versioning.service.DataSetListSnapshotService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JpaParameterServiceImpl
implements JpaParameterService {
    private static final Logger log = LoggerFactory.getLogger(JpaParameterServiceImpl.class);
    @Autowired
    protected ModelsProvider modelsProvider;
    @Autowired
    protected DataSetListSnapshotService dataSetListSnapshotService;
    @Autowired
    protected DateAuditorService dateAuditorService;
    @Autowired
    protected ClearCacheService clearCacheService;

    @Override
    @Transactional
    public Parameter createParameter(UUID dataSetId, UUID attributeId) {
        DataSet dataSet = this.modelsProvider.getDataSetById(dataSetId);
        return dataSet.createParameter(attributeId);
    }

    @Override
    @Transactional
    @CacheEvict(value={"ATP_DATASETS_DATASET_LIST_CONTEXT_CACHE_OS"}, key="#dataSetId")
    public Parameter createParameter(UUID dataSetId, UUID attributeId, String value, UUID dataSetReference, UUID listValueReference) {
        Parameter parameter = this.createParameterWithoutCommitting(dataSetId, attributeId, value, dataSetReference, listValueReference);
        this.dataSetListSnapshotService.commitEntity(parameter.getDataSet().getDataSetList().getId());
        return parameter;
    }

    @Override
    @Transactional
    public Parameter createParameterWithoutCommitting(UUID dataSetId, UUID attributeId, String value, UUID dataSetReference, UUID listValueReference) {
        Attribute attribute = this.modelsProvider.getAttributeById(attributeId);
        DataSet dataSet = this.modelsProvider.getDataSetById(dataSetId);
        Preconditions.checkArgument((!this.modelsProvider.isDsLocked(dataSetId) ? 1 : 0) != 0, (String)"Can not create parameter with attribute id %s and dataSet name: '%s', id: %s because dataset locked", (Object)attribute.getId(), (Object)dataSet.getName(), (Object)dataSet.getId());
        Parameter parameter = dataSet.createParameter(attributeId);
        AttributeTypeName attributeType = attribute.getAttributeType();
        this.setParameterValueByType(parameter, attributeType, value, dataSetReference, listValueReference);
        return parameter;
    }

    @Override
    @Transactional
    public Parameter createParameterOverlapWithoutCommitting(UUID attributeId, List<UUID> attributePath, UUID dataSetId, String value, UUID dataSetReference, UUID listValueReference) {
        DataSet dataSet = this.modelsProvider.getDataSetById(dataSetId);
        Preconditions.checkArgument((!this.modelsProvider.isDsLocked(dataSetId) ? 1 : 0) != 0, (String)"Can not create parameter with attribute in dataSet name: '%s', id: %s because dataset locked", (Object)dataSet.getName(), (Object)dataSet.getId());
        Parameter parameter = dataSet.createOverlap(attributeId, attributePath);
        AttributeTypeName attributeType = parameter.getAttributeKey().getAttributeType();
        this.setParameterValueByType(parameter, attributeType, value, dataSetReference, listValueReference);
        return parameter;
    }

    private boolean setParameterValueByType(Parameter parameter, AttributeTypeName attributeType, String stringValue, UUID dataSetReference, UUID listValueReference) {
        switch (attributeType) {
            case CHANGE: 
            case ENCRYPTED: 
            case TEXT: {
                parameter.setStringValue(stringValue);
                return true;
            }
            case DSL: {
                parameter.setDataSetReferenceId(dataSetReference);
                return true;
            }
            case LIST: {
                parameter.setListValueId(listValueReference);
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public Parameter updateParameter(UUID parameterId, String value, UUID dataSetReference, UUID listValueReference) {
        Parameter parameter = this.updateParameterWithoutCommitting(parameterId, value, dataSetReference, listValueReference);
        this.dataSetListSnapshotService.commitEntity(parameter.getDataSet().getDataSetList().getId());
        return parameter;
    }

    @Override
    @Transactional
    public Parameter updateParameterWithoutCommitting(UUID parameterId, String value, UUID dataSetReference, UUID listValueReference) {
        Parameter parameter = this.modelsProvider.getParameterById(parameterId);
        Attribute attribute = parameter.getAttribute();
        this.setParameterValueByType(parameter, attribute.getAttributeType(), value, dataSetReference, listValueReference);
        return parameter;
    }

    @Override
    @Transactional
    public void updateOverlapParameterWithoutCommitting(Parameter parameter, String value, UUID dataSetReference, UUID listValueReference) {
        AttributeTypeName attributeType = parameter.getAttributeKey().getAttributeType();
        this.setParameterValueByType(parameter, attributeType, value, dataSetReference, listValueReference);
    }

    @Override
    public List<Parameter> getBySourceIdAndDataSetId(UUID sourceId, UUID dataSetId) {
        return this.modelsProvider.getParameterBySourceIdAndDataSetId(sourceId, dataSetId);
    }

    @Override
    @Transactional
    public boolean bulkUpdateValues(String stringValue, UUID dataSetReference, UUID listValueReference, UUID dataSetListId, UUID dataSetId, List<UUID> listIdsParametersToChange) {
        List<UUID> parameterIds = dataSetId == null ? listIdsParametersToChange : this.modelsProvider.getParametersIdByDsId(dataSetId);
        parameterIds.forEach(paramIds -> {
            DataSet dataSet = this.modelsProvider.getParameterById((UUID)paramIds).getDataSet();
            Preconditions.checkArgument((!dataSet.isLocked() ? 1 : 0) != 0, (String)"Can not change list value(s) in parameter id: '%s', dataSet name: '%s', id: %s because dataset is locked", (Object)paramIds, (Object)dataSet.getName(), (Object)dataSet.getId());
        });
        boolean isUpdated = false;
        for (UUID parameterId : parameterIds) {
            Parameter parameter = this.modelsProvider.getParameterById(parameterId);
            Attribute attribute = parameter.getAttribute();
            if (attribute != null) {
                AttributeTypeName attributeType = attribute.getAttributeType();
                if (!(isUpdated |= this.setParameterValueByType(parameter, attributeType, stringValue, dataSetReference, listValueReference))) continue;
                this.clearCacheService.evictParameterCache(parameterId);
                this.clearCacheService.evictDatasetListContextCache(parameter.getDataSetId());
                continue;
            }
            log.info("Orphan parameter '{}' detected!", (Object)parameterId);
        }
        if (isUpdated && dataSetListId != null) {
            this.dateAuditorService.updateModifiedFields(dataSetListId);
            this.dataSetListSnapshotService.commitEntity(dataSetListId);
        }
        return isUpdated;
    }

    @Override
    @Transactional
    public Parameter replicate(UUID id, UUID dataSetId, UUID attributeId, UUID sourceId) throws DataSetServiceException {
        return this.modelsProvider.replicateParameter(id, dataSetId, attributeId, sourceId);
    }

    @Override
    @Transactional
    public void remove(UUID id) {
        Parameter parameter = this.modelsProvider.getParameterById(id);
        if (parameter != null) {
            parameter.remove();
            this.dataSetListSnapshotService.commitEntity(parameter.getAttribute().getDataSetList().getId());
        }
    }

    @Override
    @Transactional
    public void removeWithoutCommitting(UUID id) {
        Parameter parameter = this.modelsProvider.getParameterById(id);
        if (parameter != null) {
            parameter.remove();
        }
    }

    @Override
    @Transactional
    public void save(Parameter parameter) {
        parameter.save();
    }

    @Override
    @Transactional
    public Parameter getById(UUID id) {
        return this.modelsProvider.getParameterById(id);
    }

    @Override
    public Parameter getParameterByAttributeIdAndDataSetId(UUID attributeId, UUID dataSetId) {
        return this.modelsProvider.getParameterByAttributeIdAndDataSetId(attributeId, dataSetId);
    }
}

