/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.service.jpa.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.dataset.service.jpa.DataSetServiceException;
import org.qubership.atp.dataset.service.jpa.impl.DataSetParameterProvider;
import org.qubership.atp.dataset.service.jpa.impl.macro.MacroContext;
import org.qubership.atp.dataset.service.jpa.model.PathStep;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.DataSetListContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.GroupContext;
import org.qubership.atp.dataset.service.jpa.model.dscontext.ParameterContext;
import org.qubership.atp.dataset.service.jpa.model.tree.params.AbstractParameter;
import org.qubership.atp.dataset.service.jpa.model.tree.params.macros.ParameterPositionContext;

public class ParameterExtractor {
    private DataSetListContext dataSetListContext;
    private List<PathStep> referenceAttributePath;
    private List<UUID> fullAttributePath = new LinkedList<UUID>();
    private List<UUID> macroPosition;
    private PathStep attribute;
    private int dataSetColumn;
    private UUID dataSetId;
    private Map<ParameterPositionContext, String> cachedValues = new HashMap<ParameterPositionContext, String>();
    private DataSetParameterProvider parameterProvider;

    public ParameterExtractor(DataSetListContext dataSetListContext, UUID dataSetId, int dataSetColumn, List<UUID> macroPosition, List<PathStep> referenceAttributePath, PathStep attribute) {
        this.dataSetListContext = dataSetListContext;
        this.dataSetId = dataSetId;
        this.dataSetColumn = dataSetColumn;
        this.macroPosition = macroPosition;
        this.referenceAttributePath = referenceAttributePath;
        this.attribute = attribute;
    }

    public String extractWithProvider(DataSetParameterProvider parameterProvider) throws DataSetServiceException {
        List<DataSetContext> dataSets = this.dataSetListContext.getDataSets();
        this.parameterProvider = parameterProvider;
        if (dataSets.isEmpty()) {
            throw new DataSetServiceException("Can't find referenced variable");
        }
        if (this.macroPosition.isEmpty()) {
            return this.extractFromList(this.dataSetListContext.getDataSetListId(), this.macroPosition);
        }
        for (GroupContext group : this.dataSetListContext.getGroups()) {
            if (!this.macroPosition.get(0).equals(group.getId())) continue;
            this.fullAttributePath.add(this.macroPosition.get(0));
            try {
                return this.extractFromGroup(group, this.macroPosition.subList(1, this.macroPosition.size()), this.referenceAttributePath);
            }
            catch (DataSetServiceException e) {
                return this.extractFromList(this.dataSetListContext.getDataSetListId(), Collections.emptyList());
            }
        }
        throw new DataSetServiceException("Can't find referenced variable");
    }

    private String extractFromGroup(GroupContext group, List<UUID> macroPosition, List<PathStep> pathSteps) throws DataSetServiceException {
        if (macroPosition.isEmpty()) {
            return this.getFromGroupByPath(group, macroPosition, pathSteps);
        }
        for (GroupContext groupGroup : group.getGroups()) {
            if (!macroPosition.get(0).equals(groupGroup.getId())) continue;
            try {
                return this.extractFromGroup(groupGroup, macroPosition.subList(1, macroPosition.size()), pathSteps);
            }
            catch (DataSetServiceException e) {
                return this.getFromGroupByPath(group, Collections.emptyList(), pathSteps);
            }
        }
        throw new DataSetServiceException("Can't find referenced variable");
    }

    private String getFromGroupByPath(GroupContext group, List<UUID> macroPosition, List<PathStep> pathSteps) throws DataSetServiceException {
        if (pathSteps.isEmpty() || pathSteps.get(0).matches(group.getName(), group.getId())) {
            for (DataSetContext dataSet : group.getDataSets()) {
                if (dataSet.getColumnNumber() != this.dataSetColumn) continue;
                for (ParameterContext parameter : dataSet.getParameters()) {
                    if (!this.attribute.matches(parameter.getName(), parameter.getAttributeId())) continue;
                    return this.tryGetFromCache(this.dataSetListContext, parameter, new ParameterPositionContext(this.fullAttributePath, this.dataSetColumn, dataSet.getId(), parameter.getOrder(), group.getDataSetListId()));
                }
            }
        } else {
            for (GroupContext groupGroup : group.getGroups()) {
                if (!pathSteps.get(0).matches(groupGroup.getName(), groupGroup.getId())) continue;
                this.fullAttributePath.add(groupGroup.getId());
                return this.extractFromGroup(groupGroup, macroPosition, pathSteps.subList(1, pathSteps.size()));
            }
        }
        throw new DataSetServiceException("Can't find referenced variable");
    }

    private String extractFromList(UUID dataSetListId, List<UUID> macroPosition) throws DataSetServiceException {
        if (this.referenceAttributePath.isEmpty()) {
            for (DataSetContext dataSet : this.dataSetListContext.getDataSets()) {
                if (dataSet.getColumnNumber() != this.dataSetColumn) continue;
                List<ParameterContext> parameters = dataSet.getParameters();
                for (ParameterContext parameter : parameters) {
                    if (!this.attribute.matches(parameter.getName(), parameter.getAttributeId())) continue;
                    return this.tryGetFromCache(this.dataSetListContext, parameter, new ParameterPositionContext(Collections.emptyList(), this.dataSetColumn, dataSet.getId(), parameter.getOrder(), dataSetListId));
                }
            }
            throw new DataSetServiceException("Can't find referenced variable");
        }
        List<GroupContext> groups = this.dataSetListContext.getGroups();
        for (GroupContext group : groups) {
            if (!this.referenceAttributePath.get(0).matches(group.getName(), group.getId())) continue;
            this.fullAttributePath.add(group.getId());
            return this.extractFromGroup(group, macroPosition, this.referenceAttributePath.subList(1, this.referenceAttributePath.size()));
        }
        throw new DataSetServiceException("Can't find referenced variable");
    }

    public void setCache(Map<ParameterPositionContext, String> cachedValues) {
        this.cachedValues = cachedValues;
    }

    public String tryGetFromCache(DataSetListContext dataSetListContext, ParameterContext parameter, ParameterPositionContext positionContext) {
        if (!this.cachedValues.containsKey(positionContext)) {
            MacroContext macroContext = new MacroContext();
            macroContext.setMacroContextService(this.parameterProvider.getMacroContextService());
            macroContext.setDataSetListContext(dataSetListContext);
            macroContext.setMacros(this.parameterProvider.getAtpMacros(dataSetListContext.getVisibilityAreaId()));
            macroContext.setMacrosCalculator(this.parameterProvider.getMacrosCalculator());
            AbstractParameter dataSetParameterResolved = this.parameterProvider.getDataSetParameterResolved(dataSetListContext.getDataSetListId(), parameter.getParameterId(), parameter.getType(), true, macroContext, positionContext);
            String value = dataSetParameterResolved.getValue();
            this.cachedValues.put(positionContext, value);
            return value;
        }
        return this.cachedValues.get(positionContext);
    }
}

