/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.versioning.service.changes.processors;

import java.util.List;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.ObjectRemoved;
import org.qubership.atp.dataset.service.rest.dto.versioning.ChangeSummary;
import org.qubership.atp.dataset.service.rest.dto.versioning.HistoryItemDto;
import org.qubership.atp.dataset.versioning.service.changes.AttributeKeyComparable;
import org.qubership.atp.dataset.versioning.service.changes.DataSetListComparable;
import org.qubership.atp.dataset.versioning.service.changes.ParameterComparable;
import org.qubership.atp.dataset.versioning.service.changes.processors.AbstractChangeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=11)
public class DeleteOverlapProcessor
extends AbstractChangeProcessor {
    private static final Logger log = LoggerFactory.getLogger(DeleteOverlapProcessor.class);

    @Override
    public boolean isApplicable(Diff diff, DataSetListComparable actualEntity) {
        List<ParameterComparable> newOverlappedParameters = DeleteOverlapProcessor.findOverlappedParametersByChangeType(diff, ObjectRemoved.class);
        return !newOverlappedParameters.isEmpty();
    }

    @Override
    public HistoryItemDto createHistoryItem(Diff diff, DataSetListComparable oldEntity, DataSetListComparable actualEntity) {
        ObjectRemoved removed = DeleteOverlapProcessor.filterChangesByTypeAndAffectedType(diff, ObjectRemoved.class, "AttributeKey").get(0);
        AttributeKeyComparable attributeKey = (AttributeKeyComparable)removed.getAffectedObject().get();
        String dataSetName = DeleteOverlapProcessor.getDataSetById(actualEntity, attributeKey.getDataSetId()).getName();
        String value = attributeKey.getParameter().getValueByType().toString();
        HistoryItemDto historyItem = new HistoryItemDto();
        historyItem.setChangeSummary(ChangeSummary.OVERRIDE_DELETED.toString());
        historyItem.setAttribute(attributeKey.getAttributePathNames());
        historyItem.setDataSet(dataSetName);
        historyItem.setOldValue(value);
        log.trace("Diff processed by DeleteOverlappedParameterChangeProcessor");
        return historyItem;
    }
}

