/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import org.bson.types.ObjectId;
import org.qubership.atp.ei.node.dto.ExportFileDescriptor;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.repo.GridFsRepository;
import org.qubership.atp.ei.node.services.FileService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.stereotype.Service;
import org.springframework.util.StreamUtils;

@Service
public class ExportImportFilesService {
    private static final Logger log = LoggerFactory.getLogger(ExportImportFilesService.class);
    private final GridFsRepository gridFsRepository;
    private final FileService fileService;

    public ExportImportFilesService(GridFsRepository gridFsRepository, FileService fileService) {
        this.gridFsRepository = gridFsRepository;
        this.fileService = fileService;
    }

    public String storeInGridFs(Path dir, String processId) throws IOException {
        return this.gridFsRepository.store(Files.newInputStream(dir, new OpenOption[0]), dir.getFileName().toString(), "application/zip", processId).toString();
    }

    public Path downloadFileInDir(ExportFileDescriptor fileDescriptor, Path defaultWorkDir) {
        InputStreamResource resource = this.getResourceById(fileDescriptor.getFileId());
        Path archive = this.createExportFile(defaultWorkDir, UUID.randomUUID().toString());
        try (OutputStream os = Files.newOutputStream(archive, StandardOpenOption.APPEND);){
            StreamUtils.copy((InputStream)resource.getInputStream(), (OutputStream)os);
        }
        catch (IOException e) {
            log.error("Failed to load file {} from DB", (Object)fileDescriptor, (Object)e);
            throw new ExportException("Failed to load file from DB", e);
        }
        return archive;
    }

    public InputStreamResource getResourceById(String objectId) {
        return this.gridFsRepository.getResourceById(new ObjectId(objectId));
    }

    private Path createExportFile(Path defaultWorkDir, String fileName) throws ExportException {
        String archiveName = fileName + ".zip";
        Path archive = defaultWorkDir.resolve(archiveName);
        this.fileService.createFile(archive);
        return archive;
    }
}

