/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ei.node.services.impl;

import clover.org.apache.commons.lang3.exception.ExceptionUtils;
import feign.FeignException;
import org.qubership.atp.ei.node.clients.ExportImportFeignClient;
import org.qubership.atp.ei.node.dto.ExportImportReportRequest;
import org.qubership.atp.ei.node.dto.RunNodeRequest;
import org.qubership.atp.ei.node.dto.ValidationResult;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

@Service
public class NotifyService {
    private static final Logger log = LoggerFactory.getLogger(NotifyService.class);
    private final ExportImportFeignClient exportImportFeignClient;

    @Autowired
    public NotifyService(ExportImportFeignClient exportImportFeignClient) {
        this.exportImportFeignClient = exportImportFeignClient;
    }

    private void notifyFlow(Exception e, RunNodeRequest runNodeRequest, String exportImportType) {
        this.notifyFlow(e, runNodeRequest, exportImportType, null);
    }

    private void notifyFlow(Exception e, RunNodeRequest runNodeRequest, String exportImportType, String fileIdInGridFs) {
        ExportImportReportRequest request = new ExportImportReportRequest();
        if (fileIdInGridFs != null) {
            request.setFileId(fileIdInGridFs);
        }
        if (e != null) {
            request.setStatus("ERROR");
            request.setError(ExceptionUtils.getMessage((Throwable)e));
        } else {
            request.setStatus("COMPLETED");
        }
        this.notifyFlow(runNodeRequest, exportImportType, request);
    }

    private void notifyFlow(RunNodeRequest runNodeRequest, String exportImportType, ExportImportReportRequest request) {
        log.info("Notify export service, project {}, process {}, task {}", new Object[]{runNodeRequest.getProjectId(), runNodeRequest.getProcessId(), runNodeRequest.getTaskId()});
        try {
            this.exportImportFeignClient.report(exportImportType, runNodeRequest.getProjectId(), runNodeRequest.getProcessId(), runNodeRequest.getTaskId(), request);
        }
        catch (FeignException | RestClientException e) {
            log.error("Cannot notify export service about completeness runRequest {}, report {}", new Object[]{runNodeRequest, request, e});
            ExportException.throwException("Cannot notify export service about completeness runRequest {}, report {}", runNodeRequest, request, e);
        }
    }

    public void notifyExportFlow(RunNodeRequest request, String gridFsFileId) {
        this.notifyFlow(null, request, "export", gridFsFileId);
    }

    public void notifyExportFlow(Exception e, RunNodeRequest request) {
        this.notifyFlow(e, request, "export");
    }

    public void notifyAfterValidation(RunNodeRequest request, ValidationResult validationResult) {
        String validationStatus = validationResult.isValid() ? "VALIDATION_PASSED" : "VALIDATION_FAILED";
        ExportImportReportRequest reportRequest = new ExportImportReportRequest();
        reportRequest.setStatus(validationStatus);
        reportRequest.setMessages(validationResult.getMessages());
        reportRequest.setDetails(validationResult.getDetails());
        reportRequest.setReplacementMap(validationResult.getReplacementMap());
        this.notifyFlow(request, "import", reportRequest);
    }

    public void notifyImportFlow(RunNodeRequest request) {
        this.notifyFlow(null, request, "import");
    }

    public void notifyImportFlow(Exception e, RunNodeRequest request) {
        this.notifyFlow(e, request, "import");
    }
}

