/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.configuration;

import java.util.HashMap;
import org.qubership.atp.integration.configuration.configuration.ConditionalOnPropertyNotEmpty;
import org.qubership.atp.integration.configuration.helpers.KafkaAdminHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.kafka.core.KafkaAdmin;

@Configuration
@ConditionalOnPropertyNotEmpty(value="spring.kafka.producer.bootstrap-servers")
public class AtpIntegrationCommonKafkaConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AtpIntegrationCommonKafkaConfiguration.class);
    @Value(value="${spring.kafka.producer.bootstrap-servers}")
    private String bootstrapServers;

    @Bean
    @Lazy
    public KafkaAdmin kafkaAdmin() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("bootstrap.servers", this.bootstrapServers);
        configs.put("retries", 3);
        return new KafkaAdmin(configs);
    }

    @Bean
    public KafkaAdminHelper kafkaAdminHelper(KafkaAdmin kafkaAdmin) {
        return new KafkaAdminHelper(kafkaAdmin);
    }
}

