/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.integration.configuration.configuration;

import java.util.HashMap;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.serialization.StringSerializer;
import org.qubership.atp.integration.configuration.helpers.KafkaAdminHelper;
import org.qubership.atp.integration.configuration.model.notification.Message;
import org.qubership.atp.integration.configuration.notification.client.KafkaNotificationClient;
import org.qubership.atp.integration.configuration.notification.client.NotificationClient;
import org.qubership.atp.integration.configuration.service.NotificationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.support.serializer.JsonSerializer;

@Configuration
@EnableKafka
@ConditionalOnProperty(value={"atp.notification.mode"}, havingValue="kafka")
public class KafkaNotificationClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(KafkaNotificationClientConfiguration.class);
    @Value(value="${kafka.notification.topic.name}")
    private String kafkaTopic;
    @Value(value="${kafka.notification.topic.partitions:1}")
    private int kafkaPartitions;
    @Value(value="${kafka.notification.topic.replicas:3}")
    private short kafkaReplicas;
    @Value(value="${spring.kafka.producer.bootstrap-servers}")
    private String bootstrapServers;

    @Bean
    public KafkaAdmin admin() {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("bootstrap.servers", this.bootstrapServers);
        configs.put("retries", 3);
        return new KafkaAdmin(configs);
    }

    @Bean
    public NewTopic topic() {
        return new NewTopic(this.kafkaTopic, this.kafkaPartitions, this.kafkaReplicas);
    }

    @Bean
    public ProducerFactory<String, Message> producerFactory() {
        HashMap<String, Object> configProps = new HashMap<String, Object>();
        configProps.put("bootstrap.servers", this.bootstrapServers);
        configProps.put("key.serializer", StringSerializer.class);
        configProps.put("value.serializer", JsonSerializer.class);
        return new DefaultKafkaProducerFactory(configProps);
    }

    @Bean
    public KafkaTemplate<String, Message> kafkaTemplate(KafkaAdminHelper kafkaAdminHelper) {
        kafkaAdminHelper.createOrUpdateTopic(this.kafkaTopic, this.kafkaPartitions, this.kafkaReplicas);
        return new KafkaTemplate(this.producerFactory());
    }

    @Bean
    public NotificationClient notificationClient(@Value(value="${kafka.notification.topic.name}") String kafkaTopic, KafkaTemplate<String, Message> kafkaTemplate) {
        return new KafkaNotificationClient(kafkaTopic, kafkaTemplate);
    }

    @Bean
    public NotificationService notificationService(NotificationClient notificationClient) {
        return new NotificationService(notificationClient);
    }
}

