/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.auth.springbootstarter.security.oauth2.client.config;

import org.qubership.atp.auth.springbootstarter.security.oauth2.client.relay.TokenRelayKeycloakClientContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
@Profile(value={"default"})
public class TokenRelayReactiveConfiguration {
    private final TokenRelayKeycloakClientContext tokenContext = new TokenRelayKeycloakClientContext((AccessTokenRequest)new DefaultAccessTokenRequest());

    @Bean(value={"relayWebClient"})
    public WebClient relayWebClient(ClientHttpConnector clientHttpConnector) {
        return WebClient.builder().filter(this.authorizationToken()).clientConnector(clientHttpConnector).build();
    }

    private ExchangeFilterFunction authorizationToken() {
        return (request, next) -> next.exchange(ClientRequest.from((ClientRequest)request).headers(headers -> headers.setBearerAuth(this.tokenContext.getAccessToken().getValue())).build());
    }
}

