/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.List;
import org.javers.common.collections.Lists;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.clazz.EntityDefinitionBuilder;

public class EntityDefinition
extends ClientsClassDefinition {
    private final List<String> idPropertyNames;
    private final boolean shallowReference;

    public EntityDefinition(Class<?> entity) {
        this(new EntityDefinitionBuilder(entity));
    }

    public EntityDefinition(Class<?> entity, String idPropertyName) {
        this(new EntityDefinitionBuilder(entity).withIdPropertyName(idPropertyName));
    }

    public EntityDefinition(Class<?> entity, String idPropertyName, List<String> ignoredProperties) {
        this((EntityDefinitionBuilder)new EntityDefinitionBuilder(entity).withIdPropertyName(idPropertyName).withIgnoredProperties(ignoredProperties));
    }

    EntityDefinition(EntityDefinitionBuilder builder) {
        super(builder);
        this.idPropertyNames = Lists.immutableCopyOf(builder.getIdPropertyNames());
        this.shallowReference = builder.isShallowReference();
    }

    public boolean hasExplicitId() {
        return this.idPropertyNames.size() > 0;
    }

    public List<String> getIdPropertyNames() {
        return this.idPropertyNames;
    }

    public boolean isShallowReference() {
        return this.shallowReference;
    }
}

